[![Build-Badge][build]][commits-master]
[![Coverage-Badge][coverage]][coverage-report]
[![Go Report Card](https://goreportcard.com/badge/gitlab.com/STP-Team/SystemTestPortal)](https://goreportcard.com/report/gitlab.com/STP-Team/SystemTestPortal)
[![License: GPL v3](https://img.shields.io/badge/License-GPL%20v3-blue.svg)](https://www.gnu.org/licenses/gpl-3.0)

[coverage]: https://gitlab.com/stp-team/systemtestportal/badges/master/coverage.svg?job=test-project "Master test coverage"
[build]: https://gitlab.com/stp-team/systemtestportal/badges/master/build.svg "Master pipeline status"
[coverage-report]: https://gitlab.com/stp-team/systemtestportal/builds/artifacts/master/browse?job=test-project
[commits-master]: https://gitlab.com/stp-team/systemtestportal/commits/master

# SystemTestPortal - http://www.systemtestportal.org

SystemTestPortal is a web application that allows to create, run and analyze
manual system tests. It aims to be useful for developers, testers and end-users.

## Features

- Step-by-step execution of tests
- Organizing test cases with the help of test sequences
- Inspect protocols of test executions
- Print tests to execute them offline

Discover more on our [Homepage](http://www.systemtestportal.org/discover/).

## Quick start

Once you have [downloaded](ftp://ftp.informatik.uni-stuttgart.de/pub/se/systemtestportal/) the 
binary or compiled it yourself. The server can be started using:
```
stp --host=<the hostname (e.g. localhost or 0.0.0.0)> --port=<the port to listen to>
```
Since version 0.11.0 the server will listen to all interfaces on port 8080 by default 
(if no host or port is provided).
Earlier versions listen exclusively to localhost on port 8080.
If you are using an earlier version, but want to listen to all interfaces
you can use "" or 0.0.0.0 as hostname.


## Known issues

As described in stp-team/homepage#30 we currently have an issue with our project path that
makes it impossible to resolve the project via `go get`. To workaround this you may
manually clone the repository:
```bash
cd $(go env GOPATH)
mkdir -p src/gitlab.com/stp-team/
cd src/gitlab.com/stp-team/
git clone git@gitlab.com:stp-team/systemtestportal1.git systemtestportal
```
We are currently trying to get in contact with GitLab to resolve this issue.

## Installation guide

The installation guide can be found on [our website](http://www.systemtestportal.org/get/).

## You want to contribute?

Check out our [workflow](https://gitlab.com/STP-Team/SystemTestPortal/blob/master/CONTRIBUTING.md).

## About the developers

The SystemTestPortal is developed by students of the [Institute of Software Technology at the Universität Stuttgart](http://www.iste.uni-stuttgart.de/se) in a student project.

## License

[GNU GPL-3.0](https://opensource.org/licenses/GPL-3.0)