/* ACCESSOU(tput).CC, (c) Harry Fluks 1997

   Permission is hereby granted for unlimited modification, use, and
   distribution.  This software is made available with no warranty of
   any kind, express or implied.  This copyright notice must remain
   intact in all versions of this software.

   The author would appreciate it if any bug fixes and enhancements were
   to be sent back to him for incorporation into future versions of this
   software.  Please send changes to fluks4@pi.net

   ----

   97-01-27  created
*/

#include "accessou.h"


AccessOutputFile::AccessOutputFile(const FileName & p)
:
    MyUnformattedOutputFile(FileName(p, "acc")),
    aFileName(p)
{
    // header:
    printF("@Storycode@,");
    printF("@Country@,");
    printF("@Entrycode@,");
    printF("@Pages@,");
    printF("@Layout@,");
    printF("@Title@,");
    printF("@Heroes@,");
    printF("@Plotters@,");
    printF("@Writers@,");
    printF("@Artists@,");
    printF("@Inkers@,");
    printF("@Appearing@,");
    printF("@Rest@,");
    printF("@Rep-gl@,");
    printF("@Rep-nl@,");
    printF("@Rep-dk@,");
    printF("@Rep-de@,");
    printF("@Comment@\n");
}


AccessOutputFile::~AccessOutputFile()
{
}


void AccessOutputFile::printAllShortListFields(
    InternalEntry & pEntry,
    ShortListFieldEnum pField,
    PersonLegend & pPersonLegend)
{
    ShortList & shl = pEntry.field(pField);
    int lNumber = shl.numberOfElements();
    bool lFirst = TRUE;
    const bool cInLatin1 = TRUE; // ** right, in ACC files?

    for (int i = 0; i < lNumber; i++)
    {
        const char * lFullName =
            pPersonLegend.find(shl.element(i), pField, cInLatin1);
        if (lFullName == 0)
        {
            lFullName = shl.element(i);
        }

        if (lFullName[0] != '\0')
        {
            if (lFirst)
            {
                printF("@");
                lFirst = FALSE;
            }
            else
            {
                printF(",");
            }
            printF("%s", lFullName);
        }
    }
    if (!lFirst)
    {
        printF("@");
    }

    printF(",");
}


void AccessOutputFile::putEntry(
    InternalEntry & pEntry,
    PersonLegend & pPersonLegend)
{
    const char * lQuote = "@"; // a char that never occurs in a string!
    const char * lComma = ",";
#define quote printF(lQuote)
#define comma printF(lComma)

    if (!pEntry.sStoryCode.empty())
    {
        quote; putS(pEntry.sStoryCode); quote;
    }
    comma;

    if (pEntry.country().valid())
    {
        quote; putS(pEntry.country().abbreviation()); quote;
    }
    comma;

    if (!pEntry.sEntryCode.empty())
    {
        quote; putS(pEntry.sEntryCode); quote;
    }
    comma;

    // aUnsolved not needed
    if (!pEntry.sPages.empty())
    {
        quote; printF("%s", pEntry.sPages.theString()); quote;
    }
    comma;

    const char * ch = pEntry.sPageLayout.theString();
    if (ch[0] != ' ')
    {
        quote; printF("%s", ch); quote;
    }
    comma;

    quote;
    if (!pEntry.sTitlePrefix.empty())
    {
        printF("%s:", pEntry.sTitlePrefix.theString());
    }
    putS(pEntry.title()); quote;
    comma;

    // fields are cleared on writing

    printAllShortListFields(pEntry, eHero, pPersonLegend);
    pEntry.field(eHero).clear();

    printAllShortListFields(pEntry, ePlotter, pPersonLegend);
    pEntry.field(ePlotter).clear();

    printAllShortListFields(pEntry, eWriter, pPersonLegend);
    pEntry.field(eWriter).clear();

    printAllShortListFields(pEntry, eArtist, pPersonLegend);
    pEntry.field(eArtist).clear();

    printAllShortListFields(pEntry, eInker, pPersonLegend);
    pEntry.field(eInker).clear();

    // all appearing characters in one "field":
    if (!pEntry.field(eAppearing).empty())
    {
        quote; printF("%s", pEntry.field(eAppearing).delimitedString());
        quote;
    }
    comma;
    pEntry.field(eAppearing).clear();
    pEntry.field(eOldCode).clear(); // we don't want that one
    pEntry.field(eOldCodeA).clear(); // nor that one
    pEntry.field(eOldCodeB).clear(); // nor that one

    // all remaining fields in one "field":
    bool lQuoteUsed = FALSE;
    ShortListFieldIndex s;
    while (s.next())
    {
        if (!pEntry.field(s).empty())
        {
            if (!lQuoteUsed)
            {
                lQuoteUsed = TRUE;
                quote;
            }
            printF("%s:", s.prefix());
            printF("%s;", pEntry.field(s).delimitedString());
        }
    }
    if (lQuoteUsed)
    {
        quote;
    }
    comma;

    // all reprints of a country in one "field" - only of certain countries
    if (! pEntry.reprint(eGladstoneCountry).empty())
    {
        quote; printF("%s", pEntry.reprint(eGladstoneCountry).delimitedString()); quote;
    }
    comma;
    if (! pEntry.reprint(eNetherlandsCountry).empty())
    {
        quote; printF("%s", pEntry.reprint(eNetherlandsCountry).delimitedString()); quote;
    }
    comma;
    if (! pEntry.reprint(eDenmarkCountry).empty())
    {
        quote; printF("%s", pEntry.reprint(eSwedenCountry).delimitedString()); quote;
    }
    comma;
    if (! pEntry.reprint(eGermanyCountry).empty())
    {
        quote; printF("%s", pEntry.reprint(eGermanyCountry).delimitedString()); quote;
    }
    comma;
    if (! pEntry.comment().empty())
    {
        quote; printF("%s", pEntry.comment().element()); quote;
    }
    // no final comma;
    // no storyComment() (yet)

    printLine();
}


void AccessOutputFile::make(void)
{
    MyFixedPosInputString lInputString;

    MyInputFile lStoryInputFile(aFileName);

    PersonLegend lPersonLegend;

    while (lInputString.read(lStoryInputFile) != eEndOfFile)
    {
        InternalEntry lEntry;
        lEntry.scan(lInputString);
        putEntry(lEntry, lPersonLegend);
    }
}
