/* BARKSWEB(pages).H, (c) Harry Fluks 1995

   Permission is hereby granted for unlimited modification, use, and
   distribution.  This software is made available with no warranty of
   any kind, express or implied.  This copyright notice must remain
   intact in all versions of this software.

   The author would appreciate it if any bug fixes and enhancements were
   to be sent back to him for incorporation into future versions of this
   software.  Please send changes to fluks4@pi.net

   ----

   Object: BarksWebPages

   Object to make a collection of related web pages.

   97-06-26  created
*/

#ifndef BARKSWEB_H
#define BARKSWEB_H

#include "report.h"
#include "selected.h"
#include "personle.h"
#include "linklist.h"

const int cBufferSize = 30000; // = maximum size of a description

class BarksWebPages
{
public:
    BarksWebPages(void);
    ~BarksWebPages();

    void read(const FileName &);
    void addEntries(const FileName &);
    void write(
        const FileName &,
        PersonLegend &,
        const CountrySet &);

private:
    bool match(MyDelimitedInputString *);

    LinkList aList;
    char * aReadBuffer;
};

#endif