/* BUFFERS.H, (c) Harry Fluks 1996

   Permission is hereby granted for unlimited modification, use, and
   distribution.  This software is made available with no warranty of
   any kind, express or implied.  This copyright notice must remain
   intact in all versions of this software.

   The author would appreciate it if any bug fixes and enhancements were
   to be sent back to him for incorporation into future versions of this
   software.  Please send changes to fluks4@pi.net

   ----

   Object: Buffers

   Our own Buffer management, which may be a bit more efficient than
   the standard new / delete operations.
   Big buffers are fit for i/o operations (MyInput/MyOutput);
   small buffers are fit for entry fields (ShortList)

   96-08-14  created & checked
*/

#ifndef BUFFERS_H
#define BUFFERS_H

#include "definiti.h" // bool
#include "mylib.h" // LINEtype

static const int cMaxBuffers = 20;
// memory usage for buffers will be 20 * MAXLINEsize (500)

static const int cMediumBufferSize = 40;
static const int cMaxMediumBuffers = 800;

static const int cSmallBufferSize = 10;
static const int cMaxSmallBuffers = 500;

class Buffers
{
public:
    static char * newBuffer(int pReason, int pSize);
    // returns pointer to un-initialised data. This pointer should
    // always be freed calling 'deleteBuffer()'!
    // pReason is for fine-tuning and debugging

    static void deleteBuffer(int pReason, char *);
    // the parameter should haven been created calling 'newBuffer'.
    // pReason is for fine-tuning and debugging; it should have the
    // same value as in the corresponding newBuffer() call

    static void usePool(bool p) { aUsePool = p; }
    // using the buffer-pool prevents heap memory fragmentation.

private:
    static void initialiseIfNecessary(void);

    static bool   aUsePool;
    static bool   aInitialised;
    static char * aBuffer           [cMaxBuffers];
    static bool   aBufferUsed       [cMaxBuffers];
    static char * aMediumBuffer     [cMaxMediumBuffers];
    static bool   aMediumBufferUsed [cMaxMediumBuffers];
    static char * aSmallBuffer      [cMaxSmallBuffers];
    static bool   aSmallBufferUsed  [cMaxSmallBuffers];
    // if these buffers aren't enough, we'll use 'new'
};

#endif
