/* BUFFERS.CC, (c) Harry Fluks 1995

   Permission is hereby granted for unlimited modification, use, and
   distribution.  This software is made available with no warranty of
   any kind, express or implied.  This copyright notice must remain
   intact in all versions of this software.

   The author would appreciate it if any bug fixes and enhancements were
   to be sent back to him for incorporation into future versions of this
   software.  Please send changes to fluks4@pi.net

   ----

   96-08-14  created & checked
*/

#include <assert.h>
#include "buffers.h"

bool   Buffers::aInitialised = FALSE;
bool   Buffers::aUsePool     = TRUE;
char * Buffers::aBuffer           [cMaxBuffers];
bool   Buffers::aBufferUsed       [cMaxBuffers];
char * Buffers::aMediumBuffer     [cMaxMediumBuffers];
bool   Buffers::aMediumBufferUsed [cMaxMediumBuffers];
char * Buffers::aSmallBuffer      [cMaxSmallBuffers];
bool   Buffers::aSmallBufferUsed  [cMaxSmallBuffers];

static int gInUse = 0;
static int gBigInUse = 0;
static int gMediumInUse = 0;
static int gSmallInUse = 0;

#define cMaxReason 10
static int gReason[cMaxReason];

char * Buffers::newBuffer(int pReason, int pSize)
{
    initialiseIfNecessary();

    assert (pReason < cMaxReason);
    gReason[pReason]++;

/****************
static unsigned long int gCount = 0;
static unsigned long int gTotalSize = 0;
gCount++;
gTotalSize += pSize;
if (gCount % 500 == 0)
{
//printf("\nAv[%ld] B[%d] M[%d] S[%d] Dyn[%d]\n",
//(gTotalSize / gCount), gBigInUse, gMediumInUse, gSmallInUse, gInUse);

printf("Reasons: ");
for (int i = 0; i < cMaxReason; i++)
{
    printf("%d:%d ", i, gReason[i]);
}

printf("\n");

}
************/

    if (aUsePool)
    {
        if (pSize <= cSmallBufferSize)
        {
            for (int i = 0; i < cMaxSmallBuffers; i++)
            {
                if (! aSmallBufferUsed[i])
                {
                    aSmallBufferUsed[i] = TRUE;
                    gSmallInUse++;
                    return aSmallBuffer[i];
                }
            }
        }
        // try bigger buffers
        else if (pSize <= cMediumBufferSize)
        {
            for (int i = 0; i < cMaxMediumBuffers; i++)
            {
                if (! aMediumBufferUsed[i])
                {
                    aMediumBufferUsed[i] = TRUE;
                    gMediumInUse++;
                    return aMediumBuffer[i];
                }
            }
        }
        // try even bigger buffers
        else if (pSize <= MAXLINEsize)
        {
            for (int i = 0; i < cMaxBuffers; i++)
            {
                if (! aBufferUsed[i])
                {
                    aBufferUsed[i] = TRUE;
                    gBigInUse++;
                    return aBuffer[i];
                }
            }
        }
    }

//MyLib::debug("buffers"); /*****/

    // not aUsePool, or no room in our own buffer-arrays; let C++ handle it
    gInUse++;
    char * l = new char[pSize];
    assert(l != 0);
    return l;
}


void Buffers::deleteBuffer(int pReason, char * p)
{
    assert(aInitialised); // we can't have deleteB without a previous newB!

    assert (pReason < cMaxReason);
    gReason[pReason]--;

    int i;
    for (i = 0; i < cMaxSmallBuffers; i++)
    {
        if (p == aSmallBuffer[i])  // pointer comparison!
        {
            aSmallBufferUsed[i] = FALSE;
            gSmallInUse--;
            return;
        }
    }
    for (i = 0; i < cMaxMediumBuffers; i++)
    {
        if (p == aMediumBuffer[i])  // pointer comparison!
        {
            aMediumBufferUsed[i] = FALSE;
            gMediumInUse--;
            return;
        }
    }
    for (i = 0; i < cMaxBuffers; i++)
    {
        if (p == aBuffer[i])  // pointer comparison!
        {
            aBufferUsed[i] = FALSE;
            gBigInUse--;
            return;
        }
    }
    // no buffer found, so dynamic memory
    gInUse--;
    delete [] p;
}


void Buffers::initialiseIfNecessary(void)
{
    if (! aInitialised)
    {
        for (int j = 0; j < cMaxReason; j++)
        {
            gReason[j] = 0;
        }

        int i;
        for (i = 0; i < cMaxSmallBuffers; i++)
        {
            aSmallBuffer[i] = new char [cSmallBufferSize]; // never freed
            assert(aSmallBuffer[i] != 0);
            aSmallBufferUsed[i] = FALSE;
        }
        for (i = 0; i < cMaxMediumBuffers; i++)
        {
            aMediumBuffer[i] = new char [cMediumBufferSize]; // never freed
            assert(aMediumBuffer[i] != 0);
            aMediumBufferUsed[i] = FALSE;
        }
        for (i = 0; i < cMaxBuffers; i++)
        {
            aBuffer[i] = new char [MAXLINEsize]; // never freed
            assert(aBuffer[i] != 0);
            aBufferUsed[i] = FALSE;
        }
        aInitialised = TRUE;
    }
}
