/* CHECKLOG.H, (c) Harry Fluks 1996

   Permission is hereby granted for unlimited modification, use, and
   distribution.  This software is made available with no warranty of
   any kind, express or implied.  This copyright notice must remain
   intact in all versions of this software.

   The author would appreciate it if any bug fixes and enhancements were
   to be sent back to him for incorporation into future versions of this
   software.  Please send changes to fluks4@pi.net

   ----

   Object: CheckLog

   Logger for input checks. Keeps track of file names and line numbers.
   Uses the global 'log' function (mylib.h) for logging.

   96-07-17  created
   96-08-06  checked
*/

#ifndef CHECKLOG_H
#define CHECKLOG_H

#include "definiti.h" // bool
#include "mylib.h" // FileName
#include "pointeri.h"

static const int cMaxErrors = 22;

class CheckLog
{
public:
    CheckLog(void);
    ~CheckLog();

    void newFile(const FileName &);
    void nextLine(void);
    void log( int, const char *, const char *,                   const char *);
    void log( int, const char *, char,                           const char *);
    void log( int, const char *, const PointerIntoInputString &, const char *);

private:
    int aLineNumber;
    FileName aCurrentInputFileName;
    int aErrorCount[cMaxErrors];
};

#endif
