/* CREATORO(utput).H, (c) Harry Fluks 1995

   Permission is hereby granted for unlimited modification, use, and
   distribution.  This software is made available with no warranty of
   any kind, express or implied.  This copyright notice must remain
   intact in all versions of this software.

   The author would appreciate it if any bug fixes and enhancements were
   to be sent back to him for incorporation into future versions of this
   software.  Please send changes to fluks4@pi.net

   ----

   Objects: CreatorOutput, SubseriesOutput, CreatorIssueOutput

   CreatorOutput makes a list of stories (from the DBS files originally),
   plus unsolved entries from DBI files. Only entries of the desired
   creator are listed.

   SubseriesOutput does the same, but selects on a subseries.

   CreatorIssueOutput makes a list of entries from the DBI files.
   Only entries of the desired creator are listed.

   (SubseriesIssueOutput is not provided, since we don't want such
   a list.)

   96-01-20  created
   96-04-07  uses SELECTED.H
   96-08-12  checked
*/

#ifndef CREATORO_H
#define CREATORO_H

#include <stdio.h>
#include "selected.h"

class CreatorOutput: public SelectedOutput
{
public:
    CreatorOutput( const char * pFileName,
                   const ReportOptions &,
                   const SelectionOptions &);
    ~CreatorOutput() { }

protected:
    // redefined from SelectedOutput:
    virtual bool match(Entry & pEntry);
};


class SubseriesOutput: public SelectedOutput
{
public:
    SubseriesOutput( const char * pFileName,
                     const ReportOptions &,
                     const SelectionOptions &);
    ~SubseriesOutput() { }

private:
    virtual bool match(Entry & pEntry);
};


class CreatorIssueOutput: public CreatorOutput
{
public:
    CreatorIssueOutput( const char * pFileName,
                        const ReportOptions &,
                        const SelectionOptions &);
    ~CreatorIssueOutput() { }

    void doit(void); // overrides SelectedOutput::doit()

protected:
    // redefined from SelectedOutput:
    virtual bool headerSmallerThanEntry(const Header &, const Entry &);
};

#endif