/* CHECKLOG.CC, (c) Harry Fluks 1995

   Permission is hereby granted for unlimited modification, use, and
   distribution.  This software is made available with no warranty of
   any kind, express or implied.  This copyright notice must remain
   intact in all versions of this software.

   The author would appreciate it if any bug fixes and enhancements were
   to be sent back to him for incorporation into future versions of this
   software.  Please send changes to fluks4@pi.net

   ----

   96-07-17  created
   96-08-06  checked
*/

#include <assert.h>
#include "checklog.h"
#include "mylib.h"

const char * cErrorText[] =  // ONLY used in statistics at the end!
{
    "", // error 0
    "story code identical",
    "story code smaller",
    "entry code identical",
    "entry code smaller",
    "date",
    "story code",
    "page",
    "page empty / multipart",
    "page layout",
    "missing panels",
    "part field",
    "comment",
    "title prefix",
    "person empty / cleaning",
    "person not in table", // 15
    "header level",
    "header field",
    "maxnumber not filled in",
    "error during scan",
    "r-line in non-Western", // 20
    "person not abbreviated"
};


CheckLog::CheckLog(void)
:
    aLineNumber(0),
    aCurrentInputFileName("", "")
{
    for (int i = 0; i < cMaxErrors; i++)
    {
        aErrorCount[i] = 0;
    }
}


CheckLog::~CheckLog()
{
    MyLib::log("Error statistics:");
    for (int i = 0; i < cMaxErrors; i++)
    {
        if (aErrorCount[i] != 0)
        {
            MyLib::log("\tErr%-3d: %4d (%s)", i, aErrorCount[i], cErrorText[i]);
        }
    }
}


void CheckLog::newFile(const FileName & p)
{
    aLineNumber = 0;
    aCurrentInputFileName = p;

    printf("-"); // just some indication on the screen
}


void CheckLog::nextLine(void)
{
    aLineNumber++;
}


void CheckLog::log( int pErrorNumber,
                    const char * pFieldName,
                    const char * pStringValue,
                    const char * pMessage)
{
    MyLib::log("%-12s line %5d, Err%-3d: %s ('%s'): %s",
               aCurrentInputFileName.fullNameNoDir(),
               aLineNumber, pErrorNumber, pFieldName, pStringValue, pMessage);

    assert(pErrorNumber < cMaxErrors);
    aErrorCount[pErrorNumber] += 1;
}


void CheckLog::log( int pErrorNumber,
                    const char * pFieldName,
                    char pCharValue,
                    const char * pMessage)
{
    char l[2];
    l[0] = pCharValue;
    l[1] = '\0';
    log(pErrorNumber, pFieldName, l, pMessage);
}


void CheckLog::log( int pErrorNumber,
                    const char * pFieldName,
                    const PointerIntoInputString & pPointer,
                    const char * pMessage)
{
    char l[80]; // 80 should be more than enough for a clear log message
    pPointer.copyToChars(l, 79);
    log(pErrorNumber, pFieldName, l, pMessage);
}
