/* COMMENT.CC, (c) Harry Fluks 1996

   Permission is hereby granted for unlimited modification, use, and
   distribution.  This software is made available with no warranty of
   any kind, express or implied.  This copyright notice must remain
   intact in all versions of this software.

   The author would appreciate it if any bug fixes and enhancements were
   to be sent back to him for incorporation into future versions of this
   software.  Please send changes to fluks4@pi.net

   ----

   96-07-18  created (from shortlis.cc)
   96-08-16  checked
*/

#include <assert.h>
#include <string.h>
#include "comment.h"
#include "mylib.h"
#include "buffers.h"

Comment::Comment(void)
:
    aBuffer(0)
{
}


Comment::Comment(const char * p)
:
    aBuffer(0)
{
    append(p);
}


Comment::~Comment()
{
    if (aBuffer != 0)
    {
        Buffers::deleteBuffer(9, aBuffer);
    }
}


void Comment::clear(void)
{
    if (aBuffer != 0)
    {
        aBuffer[0] = '\0';
    }
}


const char * Comment::element(void) const
{
    if (aBuffer == 0)
    {
        return "";
    }
    else
    {
        return aBuffer;
    }
}


bool Comment::empty(void) const
{
    if (aBuffer == 0)
    {
        return TRUE;
    }
    else
    {
        return aBuffer[0] == '\0';
    }
}


void Comment::append(const char * p)
{
    if (  (p != 0)
       && (*p != '\0')
       )
    {
        reallocate(strlen(p) + 1);
        strcat(aBuffer, p);
    }
}


void Comment::append(const PointerIntoInputString & p)
{
    if (!p.empty())
    {
        reallocate(p.length() + 1);
        char * c = MyLib::atend(aBuffer);
        p.copyToChars(c, p.length());
    }
}


void Comment::append(const Comment & p)
{
    if (p.aBuffer != 0)
    {
        append(p.aBuffer);
    }
}


void Comment::reallocate(int pExtraSize)
{
    if (aBuffer == 0)
    {
        char * lBuffer = Buffers::newBuffer(9, pExtraSize);
        assert(lBuffer != 0);
        aBuffer = lBuffer;
        aBuffer[0] = '\0';
    }
    else
    {
        char * lBuffer = Buffers::newBuffer(9, strlen(aBuffer) + pExtraSize);
        assert(lBuffer != 0);
        strcpy(lBuffer, aBuffer);
        Buffers::deleteBuffer(9, aBuffer);
        aBuffer = lBuffer;
    }
}
