/* CREATORO(utput).CC, (c) Harry Fluks 1995

   Permission is hereby granted for unlimited modification, use, and
   distribution.  This software is made available with no warranty of
   any kind, express or implied.  This copyright notice must remain
   intact in all versions of this software.

   The author would appreciate it if any bug fixes and enhancements were
   to be sent back to him for incorporation into future versions of this
   software.  Please send changes to fluks4@pi.net

   ----

   Generate files with all stories of one creator

   95-03-29  created (extracted from DIZNISTO)
   96-04-07  some code moved to SELECTED.CC
   96-08-12  checked
*/

#include <assert.h>
#include "creatoro.h"

CreatorOutput::CreatorOutput(
    const char * pFileName,
    const ReportOptions & pReportOptions,
    const SelectionOptions & pSelectionOptions)
:
    SelectedOutput(
        FileName(pFileName, pSelectionOptions.aStoGaCov.extension()),
        pReportOptions,
        pSelectionOptions)
{
    if (aLayout == ReportOptions::eReprintsInColumns)
    {
        MyFormattedOutputFile & l = (MyFormattedOutputFile &) theOutputFile();
        // type cast can be done, because of the if ()
        l.changeIndentation(71); // trial and error...
    }
}


bool CreatorOutput::match(Entry & pEntry)
{
    if (!aStoGaCov.match(pEntry))
    {
        return FALSE;
    }
    if (pEntry.field(ePlotter).contains(aSelector)) return TRUE;
    if (pEntry.field(eWriter ).contains(aSelector)) return TRUE;
    if (pEntry.field(eArtist ).contains(aSelector)) return TRUE;
    if (pEntry.field(eInker  ).contains(aSelector)) return TRUE;
    return FALSE;
}


SubseriesOutput::SubseriesOutput(
    const char * pFileName,
    const ReportOptions & pReportOptions,
    const SelectionOptions & pSelectionOptions)
:
    SelectedOutput(FileName(pFileName, "subseries-index"),
                   pReportOptions, pSelectionOptions)
{
    startOwnHeader();
    theOutputFile().printF("Index of the subseries \"%s\"", aSelector);
    endOwnHeader();
}


bool SubseriesOutput::match(Entry & pEntry)
{
    if (aStoGaCov.match(pEntry))
    {
        return pEntry.field(eSer).contains(aSelector);
    }
    else
    {
        return FALSE;
    }
}


CreatorIssueOutput::CreatorIssueOutput(
    const char * pFileName,
    const ReportOptions & pReportOptions,
    const SelectionOptions & pSelectionOptions)
:
    CreatorOutput(pFileName, pReportOptions, pSelectionOptions)
{
}


void CreatorIssueOutput::doit(void)
{
    CountryIndex c;
    while (c.next())
    {
        if (aCountrySet.includes(c))
        {
            startOwnHeader();
            theOutputFile().putS(c.name());
            endOwnHeader();
            processFile(FileName(c.abbreviation(), cStep4Extension), c);
        }
    }
}


bool CreatorIssueOutput::headerSmallerThanEntry(
    const Header & pHeader,
    const Entry & pEntry)
{
    return (pEntry.sEntryCode.compare(pHeader.storyCode()) > 0);
}
