/* DBFILES.H, (c) Harry Fluks 1995

   Permission is hereby granted for unlimited modification, use, and
   distribution.  This software is made available with no warranty of
   any kind, express or implied.  This copyright notice must remain
   intact in all versions of this software.

   The author would appreciate it if any bug fixes and enhancements were
   to be sent back to him for incorporation into future versions of this
   software.  Please send changes to fluks4@pi.net

   ----

   Objects: DBSFileIndex, DBIFileIndex

   File names of the "external" input files, plus some of their properties

   95-04-10  created (from definiti.i)
   95-12-08  converted to C++
   96-08-12  checked
*/

#ifndef DBFILES_H
#define DBFILES_H

#include "external.h"
#include "country.h"

class DBSFileIndex
{
public:
    DBSFileIndex(): aIndex(0) {}

    const FileName fileName(void) const;
    bool next(void);
    Format format(void)           const;
    bool isWestern(void)          const;

private:
    int aIndex;
};


class DBIFileIndex
{
public:
    DBIFileIndex(): aCountry() {}

    const FileName fileName(void) const
    {
         return FileName(aCountry.abbreviation(), "dbi");
    }

    bool next(void)                    { return aCountry.next();         }
    Format format(void)          const;
    CountryIndex country(void)   const { return aCountry;                }
    bool isWestern(void)         const { return aCountry.isWestern();    }
    bool inLatin1(void)          const;

private:
    CountryIndex aCountry;
};

#endif
