/* ENTRY.CC, (c) Harry Fluks 1995

   Permission is hereby granted for unlimited modification, use, and
   distribution.  This software is made available with no warranty of
   any kind, express or implied.  This copyright notice must remain
   intact in all versions of this software.

   The author would appreciate it if any bug fixes and enhancements were
   to be sent back to him for incorporation into future versions of this
   software.  Please send changes to fluks4@pi.net

   ----

   95-04-10  created
*/

#include <assert.h>
#include <string.h>
#include "entry.h"
#include "mylib.h"


Entry::Entry(void)
{
    aUnsolved[0] = '\0';
}


Entry::~Entry()
{
}


void Entry::copyTitle(Entry & pOther)
{
    aTitle.copyFrom(pOther.aTitle);
}


bool Entry::goodPart(void) 
{
    const char * lPart = field(ePart).element(0);
    if (strlen(lPart) > 1)
    {
        return FALSE;  // part 10 etc.
    }
    else
    {
        switch (lPart[0])
        {
        case '\0':
        case ' ':
        case 'x':
        case '1':
        case 'f': // f = final part, no other parts known in the database
            return TRUE;
        default:
            return FALSE;
        }
    }
}


char * Entry::cleanedEntryCode(char * pBuffer)
{
    ENTRYCODEtype lAnotherBuffer;
    sEntryCode.copyToChars(lAnotherBuffer, ENTRYCODElength);
    // one extra copy, to get a 0-delimited string...

    const char * c = lAnotherBuffer;

    // skip leading spaces
    while (*c == ' ')
    {
        c++;
    }

    // replace multiple spaces by single space
    char * lBufPtr = pBuffer;
    int lSpaces = 0;

    for (; *c != '\0'; c++)
    {
        if (*c == ' ')
        {
            lSpaces++;
        }
        else
        {
            if (lSpaces > 0)
            {
                *lBufPtr++ = ' ';
            }
            lSpaces = 0;
            if (aCountry.isWestern()) // stop if minus sign
            {
                if (*c == '-')
                {
                    break; // EXIT FOR-LOOP
                }
            }
            else
            {
                // stop if lower case letter or '*'
                if (  ((*c >= 'a') && (*c <= 'z'))
                   || (*c == '*')
                   )
                {
                    break; // EXIT FOR-LOOP
                }
            }

            *lBufPtr++ = *c;
        }
    }

    *lBufPtr = '\0';

    // and now, add some extra characters

    sprintf(lBufPtr, "%s%s", partString(), changesString());

    assert(strlen(pBuffer) < ENTRYCODEsize);
    return pBuffer;
}


const char * Entry::partString(void) 
{
    // returns an indication that a story is divided into several issues:
    //   "+" if so
    //   ""  if not

    if (!field(eSequence).empty())
    {
        return "+";
    }

    switch (field(ePart).delimitedString()[0])
    {
    case '\0':
    case ' ':
    case 'x':
        return "";
    default:
        return "+"; // also deals with part 10 etc.
    }
}


const char * Entry::changesString(void) 
{
    // returns an indication that a story has been changed
    // in the following order of importance:
    //   * if redrawn etc.
    //   * if pages missing
    //   ' if panels missing
    //   empty string if (almost) exactly like original

    if (! field(eChanges).empty())
    {
        return "*";
    }
    else if (! field(eOriginalPages).empty())
    {
        if (field(ePart).empty())
        {
            return "*";
        }
        else
        {
            return "";
            // in sequences, the missing pages should be noted
            // explicitly in a "changes:" field.
        }
    }
    else if (! field(eMissingPanels).empty()) // ** won't work if the panels are missing in part 2 etc.
    {
        return "\'";
    }
    else
    {
        return "";
    }
}
