/* FIELDDEF(inition).CC, (c) Harry Fluks 1995

   Permission is hereby granted for unlimited modification, use, and
   distribution.  This software is made available with no warranty of
   any kind, express or implied.  This copyright notice must remain
   intact in all versions of this software.

   The author would appreciate it if any bug fixes and enhancements were
   to be sent back to him for incorporation into future versions of this
   software.  Please send changes to fluks4@pi.net

   ----

   95-12-08  created
   96-08-13  checked (and restructured)
*/

#include <assert.h>
#include <string.h>
#include <stdio.h>
#include "fielddef.h"


static const int cNone = -1; // somewhere outside the enums in the header file


static FieldDefinition cShortListFieldDefinition[] =
{
    { "plot",       "Plotter"               },
    { "writ",       "Writer"                },
    { "art",        "Artist"                },
    { "ink",        "Inker"                 },
    { "hero",       "Hero"                  },
    { "app",        "Appearance"            },
    { "code",       "Actual code"           },
    { "sequence",   "Sequence till issue"   },
    { "chapter",    "Chapter"               },
    { "re",         "Also reprinted"        },
    { "ser",        "Sub-series"            },
    { "oldcode",    "Old Database code"     },
    { "oldcodea",   "VERY old Database code"},
    { "oldcodeb",   "VERY old Database code"},
    { "exactpages", "Exact number of pages" },
    { "changes",    "Changes"               },

    { "origpg",     "Original pages"        },
    { "missing",    "Missing panels"        },
    { "part",       "Part"                  },
    { "date",       "Date"                  },
    { "enddate",    "End date"              },

    { "xref",       "Cross reference"       },
    { "xrefd",      "Cross referenced by"   },

    { "??",         "??"                    }
};


static FieldDefinition cHeaderFieldDefinition[] =
{
    { "altcode",  "" },  // we don't need explanations at the moment...
    { "date",     "" },
    { "publ",     "" },
    { "inx",      "" },
    { "min",      "" },
    { "max",      "" },
    { "reprints", "" },
    { "issues",   "" },
    { "matla",    "" },
    { "price",    "" },
    { "pages",    "" }
};


static FieldDefinition cPersonFieldDefinition[] =
{
    { "lastname", "" },
    { "firstname", "" },
    { "lastname1", "" },
    { "firstname1", "" },
    { "pseudonym", "" },
    { "altnames", "" },
    { "comment", "" },
    { "xprefix", "" },
    { "xcode", "" },
    { "xtitle", "" }
};


static FieldDefinition cRoleFieldDefinition[] =
{
    { "plotter", "" },
    { "writer",  "" },
    { "artist",  "" },
    { "inker",   "" },
    { "covers",  "" },
    { "hero",    "" },
    { "app",     "" },
    { "indexed", "" },
    { "norole",  "" } // eNoRole
};


static FieldDefinition cStoryCommentFieldDefinition[] =
{
    { "story-comm", "" }
};


FieldIndex::FieldIndex(FieldDefinition * p, int pLast)
:
    aNumber(cNone),
    aDefinitionArray(p),
    aLast(pLast)
{
}


bool FieldIndex::next(void)
{
    if (aNumber == cNone)
    {
        aNumber = 0; // the first one in the array
    }
    else
    {
        if (aNumber != aLast)
        {
            aNumber++;
        }
    }
    return aNumber != aLast;
}


bool FieldIndex::valid(void) const
{
    return aNumber >= 0 && aNumber < aLast;
}


const char * FieldIndex::prefix(void) const
{
    assert(valid());
    return aDefinitionArray[aNumber].sPrefix;
}


const char * FieldIndex::explanation(void) const
{
    assert(valid());
    return aDefinitionArray[aNumber].sExplanation;
}


void FieldIndex::initFromPointer(const PointerIntoInputString & p)
{
    aNumber = cNone;
    while (next())
    {
        if (p.equal(prefix()))
        {
            return;
        }
    }

    aNumber = cNone;
}


ShortListFieldIndex::ShortListFieldIndex(void)
:
    FieldIndex(cShortListFieldDefinition, eLastShortListField)
{
}


ShortListFieldIndex::ShortListFieldIndex(ShortListFieldEnum p)
:
    FieldIndex(cShortListFieldDefinition, eLastShortListField)
{
    aNumber = (int) p;
    assert(valid());
}


ShortListFieldIndex::ShortListFieldIndex(const PointerIntoInputString & p)
:
    FieldIndex(cShortListFieldDefinition, eLastShortListField)
{
    initFromPointer(p);
}


HeaderFieldIndex::HeaderFieldIndex(void)
:
    FieldIndex(cHeaderFieldDefinition, eLastHeaderField)
{
}


HeaderFieldIndex::HeaderFieldIndex(const PointerIntoInputString & p)
:
    FieldIndex(cHeaderFieldDefinition, eLastHeaderField)
{
    initFromPointer(p);
}


PersonFieldIndex::PersonFieldIndex(void)
:
    FieldIndex(cPersonFieldDefinition, eLastPersonField)
{
}


PersonFieldIndex::PersonFieldIndex(const PointerIntoInputString & p)
:
    FieldIndex(cPersonFieldDefinition, eLastPersonField)
{
    initFromPointer(p);
}


RoleFieldIndex::RoleFieldIndex(void)
:
    FieldIndex(cRoleFieldDefinition, eLastRoleField)
{
}


RoleFieldIndex::RoleFieldIndex(const PointerIntoInputString & p)
:
    FieldIndex(cRoleFieldDefinition, eLastRoleField)
{
    initFromPointer(p);
}


StoryCommentFieldIndex::StoryCommentFieldIndex(void)
:
    FieldIndex(cStoryCommentFieldDefinition, eLastStoryCommentField)
{
}


StoryCommentFieldIndex::StoryCommentFieldIndex(const PointerIntoInputString & p)
:
    FieldIndex(cStoryCommentFieldDefinition, eLastStoryCommentField)
{
    initFromPointer(p);
}


const char * StoryCommentFieldIndex::thePrefix(void)
{
    return cStoryCommentFieldDefinition[0].sPrefix;
}