/* FILEARRA(y).CC, (c) Harry Fluks 1994, 1995

   Permission is hereby granted for unlimited modification, use, and
   distribution.  This software is made available with no warranty of
   any kind, express or implied.  This copyright notice must remain
   intact in all versions of this software.

   The author would appreciate it if any bug fixes and enhancements were
   to be sent back to him for incorporation into future versions of this
   software.  Please send changes to fluks4@pi.net

   ----

   96-06-21  created
   96-08-06  checked
*/

#include "filearra.h"
#include <assert.h>

CountryFileArray::CountryFileArray(char * pExtension)
{
    CountryIndex c;

    while (c.next())
    {
        aFile[c.number()] =
            new MyInternalOutputFile(FileName(c.abbreviation(), pExtension));
        assert(aFile[c.number()] != 0);
    }
}


CountryFileArray::~CountryFileArray()
{
    CountryIndex c;

    while (c.next())
    {
        delete aFile[c.number()]; // will close the file
    }
}


MyInternalOutputFile & CountryFileArray::element(const CountryIndex & pCountryIndex)
{
    assert(pCountryIndex.valid());
    MyInternalOutputFile * lFile = aFile[pCountryIndex.number()];
    assert (lFile != 0);
    return *lFile;
}


// note: the length of this array is fixed; all lines should be filled in!
static FieldDefinition cStoryFileDefinition[cMaxStoryFiles] =
{
    // we use sPrefix for the file name, and sExplanation for the
    // initials = first chars of a story code.
    // This array should be sorted by story code!!
    { "a", "ABC" },
    { "d", "D" },
    { "f", "FGH" },
    { "i", "I" },
    { "k", "KR" },
    { "s", "S" },
    { "w", "W" },
    { "w2", "@" },   // extra file for W-codes
    { "w3", "@" },   // extra file for W-codes
    { "y", "YZ" }
    // story codes should start with one of these letters. If not, they
    // should be in an "unsolved" file.
};


StoryFileIndex::StoryFileIndex(void)
:
    FieldIndex(cStoryFileDefinition, cMaxStoryFiles)
{
}


StoryFileIndex::StoryFileIndex(const EntryOrStoryCode & pStoryCode)
:
    FieldIndex(cStoryFileDefinition, cMaxStoryFiles)
{
    char lChar = pStoryCode[0];

    if (lChar == 'Y' || lChar == 'Z')
    {
        if (pStoryCode.length() <= 5)
        {
            // too short newspaper code
            aNumber = -1; // invalid
            return;
        }
    }
    else
    {
        if (pStoryCode.length() <= 2)
        {
            // too short code
            aNumber = -1; // invalid
            return;
        }
    }

    // find the character in the array
    for (aNumber = 0; aNumber < cMaxStoryFiles; aNumber++)
    {
        if (strchr(cStoryFileDefinition[aNumber].sExplanation, lChar) != 0)
        {
            if (lChar == 'W')
            {
                if (pStoryCode[1] > ' ')
                {
                    aNumber += 2;
                }
                else if (pStoryCode[1] == ' ')
                {
                    if (pStoryCode[2] >= 'W')
                    {
                        aNumber += 2;
                        // select the extra file for codes starting "W WDC" etc.
                        // There are too many W-codes for only one file...
                    }
                    else if (pStoryCode[2] >= 'O')
                    {
                        aNumber += 1; // for "W OS" etc.
                    }
                }
            }
            return; // OK
        }
    }
    // not in array => invalid story code
    aNumber = -2;
}


StoryFileArray::StoryFileArray(char * pExtension)
{
    for (int i = 0; i < cMaxStoryFiles; i++)
    {
        aFile[i] =
            new MyInternalOutputFile(
                FileName(cStoryFileDefinition[i].sPrefix, pExtension));
        assert(aFile[i] != 0);
    }
}


StoryFileArray::~StoryFileArray()
{
    for (int i = 0; i < cMaxStoryFiles; i++)
    {
        delete aFile[i]; // will close the file
    }
}


MyInternalOutputFile & StoryFileArray::element(StoryFileIndex p)
{
    assert(p.valid());
    return *aFile[p.number()];
}
