/* INDEXEDI(ssueRange).H, (c) Harry Fluks 1996

   Permission is hereby granted for unlimited modification, use, and
   distribution.  This software is made available with no warranty of
   any kind, express or implied.  This copyright notice must remain
   intact in all versions of this software.

   The author would appreciate it if any bug fixes and enhancements were
   to be sent back to him for incorporation into future versions of this
   software.  Please send changes to fluks4@pi.net

   ----

   Object: IndexedIssueRange

   Range of (not) indexed issues. From header information is determined
   which issues should be there. This is checked against the actually
   indexed issues.

   The number of an issue may not exceed "cMaxIssueNumber".

   Irregularities in the header input are logged using the "mylib" log
   function.

   Used in "headeroutput" for creating a legend of indexed issues.

   96-07-18  created
   96-08-07  checked
   97-05-02  addToUnindexed added (not completely implemented yet)
*/

#ifndef INDEXEDI_H
#define INDEXEDI_H

#include "header.h"

const int cMaxIssueNumber = 2500;
// last one should always be unused
// enough to cope with Topolino and Journal de Mickey...

class IndexedIssueRange
{
public:
    IndexedIssueRange(Header &);
    // initialise from a level 1 or 2 header.

    void write(MyFormattedOutputFile &);
    // write a formatted report of the indexe issues to the output file

    void addNumber(const PointerIntoInputString & pIssueCode);
    // scan the issue code, and add its number to the range

    void addToUnindexed(const PointerIntoInputString & pIssueCode);
    // scan the issue code, and add its number to the unindexed issues

private:
    int findNumber(const PointerIntoInputString & pIssueCode);

    void printVerdict(MyFormattedOutputFile &,
                      int pListed,
                      int pNotListed);

    STORYCODEtype aRangeCode;
    // the letters of the range; every issue in the range has a code
    // starting with these letters

    TITLEtype aRangeTitle;

    int aMinNumber; // lowest possible number in the range
    int aMaxNumber; // highest possible number in the range

    bool aCheckAllListed;
    // If header field "max" has no value or a strange value, aCheckAllListed
    // is set to FALSE. No report on completeness will be done.

    bool aAllListedGuaranteed;
    // If header field "max" has the value "!", this attribute is set to
    // TRUE. Don't check on indexed issues; always report "complete range"
    // Can be used if a range has no consecutive numbering.

    bool aOccurs[cMaxIssueNumber]; // the actual occurring numbers
    char aLevel;
};

#endif
