/* INPUTCHE(cker).H, (c) Harry Fluks 1996

   Permission is hereby granted for unlimited modification, use, and
   distribution.  This software is made available with no warranty of
   any kind, express or implied.  This copyright notice must remain
   intact in all versions of this software.

   The author would appreciate it if any bug fixes and enhancements were
   to be sent back to him for incorporation into future versions of this
   software.  Please send changes to fluks4@pi.net

   ----

   Object: InputChecker

   Checks the input files. Either all files (DBS and DBI), or a single given
   file.

   96-07-17  created
   96-08-13  checked
*/

#ifndef INPUTCHE_H
#define INPUTCHE_H

#include "definiti.h" // bool
#include "shortlis.h"
#include "external.h"
#include "dbfiles.h"
#include "checklog.h"
#include "personle.h"
#include "pointeri.h"

class InputChecker
{
public:
    InputChecker(bool pListComments);
    // if pListComments = TRUE, all comments will be logged (this can be used
    // to check for erroneous perfixes)

    ~InputChecker();

    void checkAllFiles(void);
    void checkFile(const FileName &);

private:
    // note: several check routines actually change the checked subject!
    //       spaces are added to the desired length to ease the check
    void checkStoryCodeSequence(
        const PointerIntoInputString & pStoryCode, bool pInHeader);
    void checkEntryCodeSequence(
        const PointerIntoInputString & pEntryCode, bool pInHeader);

    void checkDate           (const char *);
    void checkStoryCode      (const PointerIntoInputString &, Format);
    void checkPages          (const Pages &,
                              ShortList & pPart,
                              const ShortList & pExactPages, Format);
    void checkPageLayout     (const PageLayout);
    void checkMissingPanels  (const char *);
    void checkPart           (const char *);
    void checkComment        (const Comment &, const char * pWhat);
    void checkTitle          (const TitlePrefix & pTitlePrefix,
                              const PointerIntoInputString & pTitle);
    void checkPerson         (ShortList &,
                              const char * pErrorText,
                              PersonList &);
    void checkHeaderLevel    (char);

    void checkEntry          (ExternalEntry &, bool pInEntryFile);
    void checkStoryHeader    (MyFixedPosInputString &);
    void checkIssueHeader    (MyFixedPosInputString &);

    void processOneStoryFile (DBSFileIndex &);
    void processOneEntryFile (const FileName &, bool pIsWestern);

    // attributes:
    CheckLog aCheckLog;
    STORYCODEtype aPreviousStoryCode;
    ENTRYCODEtype aPreviousEntryCode;
    bool aListComments;
    PersonList aHeroList;
    PersonList aCreatorList;
    PersonList aSubseriesList;
};

#endif
