/* INTERNAL(entry).H, (c) Harry Fluks 1995

   Permission is hereby granted for unlimited modification, use, and
   distribution.  This software is made available with no warranty of
   any kind, express or implied.  This copyright notice must remain
   intact in all versions of this software.

   The author would appreciate it if any bug fixes and enhancements were
   to be sent back to him for incorporation into future versions of this
   software.  Please send changes to fluks4@pi.net

   ----

   Object: InternalEntry

   Wrapper around Entry with functions to read and write the Entry records
   from/to files in the internal format

   95-03-23  created (using FORMATS.I)
   95-12-08  converted to C++
   96-08-16  checked
*/

#ifndef INTERNAL_H
#define INTERNAL_H

#include "definiti.h" // bool
#include "entry.h"
#include "myinput.h"
#include "myoutput.h"

class InternalEntry: public Entry
{
public:
    void scan (MyDelimitedInputString &, bool pCountryOnly = FALSE);
    // If pCountryOnly, only the story code and country is scanned from
    // the input. This is faster in cases we don't need anything else.

    void put (MyInternalOutputFile &);
};

#endif
