/* LINKLIST.H, (c) Harry Fluks 1995

   Permission is hereby granted for unlimited modification, use, and
   distribution.  This software is made available with no warranty of
   any kind, express or implied.  This copyright notice must remain
   intact in all versions of this software.

   The author would appreciate it if any bug fixes and enhancements were
   to be sent back to him for incorporation into future versions of this
   software.  Please send changes to fluks4@pi.net

   ----

   Objects: Listable, LinkList

   A very simple linked list. Elements that should be contained in the
   list must inherit from Listable.

   Calling createIndex on a list will speed up the find(). When an
   insert() or drop() is called, the index will be cleared
   automatically.

   A list without index will work fine, but slower.

   94-09-26  completed
   95-11-26  C++ version (no template)
   96-08-07  checked
*/

#ifndef LINKLIST_H
#define LINKLIST_H

class Listable
{
    friend class LinkList; // defined below
public:
    Listable(void): aPrevious(0), aNext(0) { }
    virtual ~Listable() { }

    virtual int compare(const char *) = 0;
    // To be defined by the derived class.
    // Return code:
    // -1 if "smaller"
    //  0 if "equal"
    // +1 if "greater"
    // This is needed for keeping the list elements in the right order.

    Listable * next     (void) const { return aNext; }
    Listable * previous (void) const { return aPrevious; }

private:
    Listable * aPrevious;
    Listable * aNext;
};


class LinkList
{
public:
    LinkList(void);
    ~LinkList();

    Listable * insert(Listable * pNew, const char * pKey);
    void       append(Listable * pNew);
    Listable * drop(Listable * pCurrent);
    Listable * first(void) const;
    Listable * last(void) const;
    Listable * find(const char * pKey) const;
    void       createIndex(void);

private:
    Listable * findIndexed(const char * pKey,
                           int pLower, int pUpper) const;
    Listable * findLinear(const char * pKey) const;
    void       clearIndex(void);

    Listable *   aStart;
    Listable *   aEnd;
    Listable * * aIndex;  // an array of pointers, for faster 'find()'
    int aSize;            // the size of the aIndex array
};

#endif