/* LINKLIST.C

   This software is made available with no warranty of
   any kind, express or implied.  This copyright notice must remain
   intact in all versions of this software.

   The author would appreciate it if any bug fixes and enhancements were
   to be sent back to him for incorporation into future versions of this
   software.  Please send changes to fluks4@pi.net

   ----

   94-09-26  completed
   96-08-07  checked
*/

#include <assert.h>
#include "linklist.h"

LinkList::LinkList(void)
:
    aStart(0),
    aEnd(0),
    aIndex(0),
    aSize(0)
{
}


LinkList::~LinkList()
{
    clearIndex();
}


Listable * LinkList::insert(Listable * pNew, const char * pKey)
{
    clearIndex();
    // we don't want to bother keeping the index up to date

    if (aStart == 0)
    {
        aStart = pNew;
        aEnd = pNew;
    }
    else
    {
        Listable * lPrevious  = 0;
        Listable * lCurrent   = aStart;

        while (  (lCurrent != 0)
              && (lCurrent->compare(pKey) < 0)
              )
        {
            lPrevious = lCurrent;
            lCurrent = lCurrent->aNext;
        }

        if (lPrevious == 0)
        {
            pNew->aNext = lCurrent;
            lCurrent->aPrevious = pNew;
            aStart = pNew;
        }
        else
        {
            pNew->aPrevious = lPrevious;
            lPrevious->aNext = pNew;
            pNew->aNext = lCurrent;
            if ( lCurrent == 0 )
            {
                aEnd = pNew;
            }
            else
            {
                lCurrent->aPrevious = pNew;
            }
        }
    }
    return pNew;
}


void LinkList::append(Listable * pNew)
{
    clearIndex();

    pNew->aPrevious = aEnd;
    // pNew->aNext = 0; already in constructor

    if (aStart == 0)
    {
        aStart = pNew;
    }
    else
    {
        aEnd->aNext = pNew;
    }
    aEnd = pNew;
}


Listable * LinkList::drop(Listable * pCurrent)
// will not delete pCurrent, only remove it from the list
{
    Listable * lReturn = 0;

    assert(pCurrent != 0);
    clearIndex();

    if (pCurrent->aNext != 0)
    {
        lReturn = pCurrent->aNext;
    }
    else
    {
        // at end of list
        lReturn = pCurrent->aPrevious;
        aEnd = lReturn;
    }

    if (pCurrent->aPrevious != 0)
    {
        (pCurrent->aPrevious)->aNext = pCurrent->aNext;
    }
    else
    {
        // First in chain
        aStart = pCurrent->aNext;
    }

    if (pCurrent->aNext != 0 )
    {
        (pCurrent->aNext)->aPrevious = pCurrent->aPrevious;
    }

    pCurrent->aNext = 0;
    pCurrent->aPrevious = 0;

    return lReturn;
}


Listable * LinkList::first(void) const
{
    return aStart;
}


Listable * LinkList::last(void) const
{
    return aEnd;
}


Listable * LinkList::findIndexed(const char * pKey,
                                 int pLower, int pUpper) const
{
    // first time call with:
    //             pLower = 0
    //             pUpper = array size - 1
    // (see below)

    int lHalf;
    int lCompare;

    if (pLower >= pUpper)
    {
        if (pLower >= aSize)
        {
            return 0; // array is empty
        }
        else if (aIndex[pLower]->compare(pKey) == 0)
        {
            return aIndex[pLower];
        }
        else
        {
            return 0;
        }
    }

    lHalf = pLower + (int) ((pUpper - pLower)/2) ;

    lCompare = aIndex[lHalf]->compare(pKey);
    if (lCompare == 0)
    {
        return aIndex[lHalf];
    }
    else if (lCompare > 0)
    {
        return findIndexed(pKey, pLower, lHalf - 1);
    }
    else // lCompare < 0
    {
        return findIndexed(pKey, lHalf + 1, pUpper);
    }
}


Listable * LinkList::findLinear(const char * pKey) const
{
    Listable * lCurrent;

    lCurrent = aStart;
    while (  (lCurrent != 0)
          && (lCurrent->compare(pKey) != 0)
          )
    {
        lCurrent = lCurrent->aNext;
    }
    return lCurrent;
}


Listable * LinkList::find(const char * pKey) const
{
    if (aIndex == 0)
    {
        return findLinear(pKey);
    }
    else
    {
        return findIndexed(pKey, 0, aSize - 1);
    }
}


void LinkList::createIndex(void)
{
    if (aIndex != 0)
    {
        return; // index already created
    }

    aSize = 0;
    Listable * lCurrent = aStart;
    while (lCurrent != 0)
    {
        aSize++;
        lCurrent = lCurrent->aNext;
    }

    aIndex = new Listable * [aSize];
    assert(aIndex != 0);

    lCurrent = aStart;
    int lCount = 0;
    while (lCurrent != 0)
    {
        aIndex[lCount] = lCurrent;

        lCurrent = lCurrent->aNext;
        lCount++;
    }
}


void LinkList::clearIndex(void)
{
    if (aIndex != 0)
    {
        // we don't want to bother keeping the index up to date
        delete [] aIndex;
        aIndex = 0;
    }
}
