/* PAGES.H, (c) Harry Fluks 1995

   Permission is hereby granted for unlimited modification, use, and
   distribution.  This software is made available with no warranty of
   any kind, express or implied.  This copyright notice must remain
   intact in all versions of this software.

   The author would appreciate it if any bug fixes and enhancements were
   to be sent back to him for incorporation into future versions of this
   software.  Please send changes to fluks4@pi.net

   ----

   Object: Pages

   Object to contain the number of pages: a whole number (0 - 99)
   and an indication of broken pages (' ' = no, '+' = yes)

   96-09-24  created
*/

#ifndef PAGES_H
#define PAGES_H

#include "definiti.h"

class Pages
{
public:
    Pages(void);
    ~Pages();

    void clear(void);
    void set(const Pages &);
    void set(const char *);
    // length of parameter string is irrelevant - 'set' will only look at
    // first 2 characters

    void setBroken(bool);

    bool empty(void) const;
    bool isBroken(void) const;
    bool onePageOrLess(void) const;
    const char * theString(void) const;
    bool equalTo(const Pages &) const;

    bool valid(void) const;
    // valid if first two chars:
    // - 2 digits
    // - space + 1 digit
    // - space + '?'
    // - 2 spaces

private:
    char aContents[4];
    // always fixed length: 3 characters. Last char is ' ' or '+'.
};

#endif
