/* PERSONLI(st).H, (c) Harry Fluks 1994, 1995

   Permission is hereby granted for unlimited modification, use, and
   distribution.  This software is made available with no warranty of
   any kind, express or implied.  This copyright notice must remain
   intact in all versions of this software.

   The author would appreciate it if any bug fixes and enhancements were
   to be sent back to him for incorporation into future versions of this
   software.  Please send changes to fluks4@pi.net

   ----

   Objects: PersonListElement, PersonList

   A list of persons (creators, heroes, subseries and/or indexers).

   PersonList - create a legend at the end of a file, or a list for
                searching Persons

   95-06-22  created (from LEGENDS.C)
   95-12-08  converted to C++
   96-08-12  checked
   97-04-29  subclasses (HeroList etc.) removed
   97-09-01  new subclasses (GlobalPersonList) introduced
*/

#ifndef PERSONLI_H
#define PERSONLI_H

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "internal.h"
#include "header.h"
#include "mylib.h"
#include "linklist.h"
#include "person.h"

class PersonListElement: public Listable, public Person
{
public:
    PersonListElement(const char * pLastName = 0);
    virtual ~PersonListElement();

    virtual int compare(const char *); // redefined from Listable
};


class PersonList
{
public:
    PersonList(bool pCompletePersons);
    virtual ~PersonList();

    // FIND

    const char * find(const char * pPersonCode, bool pInLatin1);
    // returns the full name of the person, or null if not found

    const char * findPersonCode(const char * pFullName);
    // returns the code, or null if not found
    // this one is used in "InputChecker" and utility programs

    // INPUT

    void readFromInternalFile(const FileName &);
    void readFromExternalFile(const FileName &, bool pCreatorLayout);

    // OUTPUT

    void writeToInternalFile(const FileName &);

    void writeFileLegend(
        MyExternalOutputFile &,
        const char * pHeaderText,
        bool pInLatin1) const;
    // appends a legend to the output file. Only used persons are
    // written.

    // ADD

    void addPersons(Entry &, ShortListFieldEnum, RoleFieldEnum);
    // add persons from the entry: field "ShortListFieldEnum", in the role
    // pRole. This role is used in the global legend output.

    void addPersons(Header &, HeaderFieldEnum, int pNumberOfTimes, RoleFieldEnum);
    // add persons from the header: field "HeaderFieldEnum", in the role
    // pRole. This role is used in the global legend output.
    // The counter will be increased "pNumberOfTimes".

    void usePersons(ShortList &);
    // mark persons as 'used'

    void reInitialise(void);
    // sets all persons to 'unused'.

    static char * cleanPerson( const char * pPerson,
                               bool & pFirst,
                               char * pBuffer);
    // Removes additions like '?', '(..)'. If the pPerson is followed
    // by "(1st", the parameter pFirst is set to TRUE.
    // Return value is a pointer to pBuffer.

protected:
    Listable * findClean(const char *);
    Listable * add(const char *, bool &);

    // attributes:
    LinkList aList;
    bool aCompletePersons;
};

#endif
