/* POINTERI(ntoInputString).H, (c) Harry Fluks 1996

   Permission is hereby granted for unlimited modification, use, and
   distribution.  This software is made available with no warranty of
   any kind, express or implied.  This copyright notice must remain
   intact in all versions of this software.

   The author would appreciate it if any bug fixes and enhancements were
   to be sent back to him for incorporation into future versions of this
   software.  Please send changes to fluks4@pi.net

   ----

   Objects: PointerIntoInputString, EntryOrStoryCode

   PointerIntoInputString is a pointer into a MyInputString. There is some
   administration to ensure that the MyInputString is not deleted before
   this object doesn't need it anymore.

   A PointerIntoInputString never has trailing spaces.

   An EntryOrStoryCode is a PointerIntoInputString with some extra features

   96-08-02  created
   96-08-13  checked
*/

#ifndef POINTERI_H
#define POINTERI_H

#include <string.h>
#include <stdio.h>
#include "definiti.h" // bool

class MyInputString;

class PointerIntoInputString
{
public:
    PointerIntoInputString(void);
    ~PointerIntoInputString();
    // not virtual, saves space. make sure we don't use polymorphism (!)

    // queries:
    bool empty(void) const;
    int length(void) const;

    bool operator== (const PointerIntoInputString & pOther) const;
    bool operator== (const char *) const;

    bool operator!= (const PointerIntoInputString & pOther) const;
    bool operator!= (const char *) const;

    char operator[](int pIndex) const;

    int compare(const PointerIntoInputString & pOther) const;
    int compare(const char *) const;
    // same return value as strcmp

    bool equal(const char *) const;

    bool equalOrLonger(const PointerIntoInputString & pOther) const;
    bool equalOrLonger(const char *) const;
    // TRUE if 'this' contains at least 'pOther' in the first chars

    const char * zeroString(void) const;
    // should only be used when a 0-terminated string is really
    // necessary, e.g. in a 'printf'. Returns a pointer to a static
    // buffer, so can only be used once at a time

    // modifiers:
    void pointTo(MyInputString * p, const char * pPointer, int pLength);
    void pointTo(const char *); // so NOT pointing into an InputString!
    void copyFrom(const PointerIntoInputString & pOther);

    // output:
    void copyToChars        (char * pTarget, int pMaxLength) const;
    void copyToCharsAligned (char * pTarget, int pLength) const;
    void copyToFile         (FILE * pTarget) const;
    void copyToFileAligned  (FILE * pTarget, int pLength) const;

protected:
    void trimTrail(void);

    const char * aPointer;  // not a 0-terminated string, so we also
    int aLength;            // need the length of the string
    MyInputString * aUsedInputString;
};


class EntryOrStoryCode: public PointerIntoInputString
{
public:
    EntryOrStoryCode(void);

    // Next functions are to detect "W"-codes...
    // Quite a dirty trick, actually. Can go awfully wrong if not used
    // with care!

    bool startsWithWSpace(void);
    // if TRUE, shiftRight can be used

    bool plusWIs(const EntryOrStoryCode & pOther) const;

    void shiftRight(void);
    // "W WDC.." -> "WDC.."
    // Precondition: startsWithWSpace()

    void shiftLeft (void);
    // shift back
    // Precondition: shiftRight() was called!
};

#endif