/* PAGES.CC, (c) Harry Fluks 1995

   Permission is hereby granted for unlimited modification, use, and
   distribution.  This software is made available with no warranty of
   any kind, express or implied.  This copyright notice must remain
   intact in all versions of this software.

   The author would appreciate it if any bug fixes and enhancements were
   to be sent back to him for incorporation into future versions of this
   software.  Please send changes to fluks4@pi.net

   ----

   96-09-24  created
*/

#include "pages.h"
#include <string.h>


Pages::Pages(void)
{
    clear();
}


Pages::~Pages()
{
}


void Pages::clear(void)
{
    strcpy(aContents, "   "); // 3 spaces
}


void Pages::set(const Pages & p)
{
    strcpy(aContents, p.aContents);
}


void Pages::set(const char * p)
{
    clear();
    if (p[0] != '\0')
    {
        aContents[0] = p[0];
        if (p[1] != '\0')
        {
            aContents[1] = p[1];
        }
    }
    // aContents[2] keeps old value
    // don't look at p[2] etc.
}


void Pages::setBroken(bool p)
{
    if (p)
    {
        aContents[2] = '+';
    }
    else
    {
        aContents[2] = ' ';
    }
}


bool Pages::empty(void) const
{
    return (strcmp(aContents, "   ") == 0);
}


bool Pages::isBroken(void) const
{
    return aContents[2] != ' ';
}


bool Pages::onePageOrLess(void) const
{
    // less than 1 page:
    if (  (aContents[0] == ' ')
       && (aContents[1] == '0')
       )
    {
        return TRUE;
    }

    // exactly 1 page:
    if (strcmp(aContents, " 1 ") == 0)
    {
        return TRUE;
    }
    return FALSE;
}


const char * Pages::theString(void) const
{
    return aContents;
}


bool Pages::equalTo(const Pages & p) const
{
    return (strcmp(aContents, p.aContents) == 0);
}


bool Pages::valid(void) const
{
    switch (aContents[0])
    {
    case '0': case '1': case '2': case '3': case '4':
    case '5': case '6': case '7': case '8': case '9':
    case ' ':
        break;
    default:
        return FALSE;
    }

    switch (aContents[1])
    {
    case '0': case '1': case '2': case '3': case '4':
    case '5': case '6': case '7': case '8': case '9':
        break;
    case ' ':
    case '?':
        if (aContents[0] != ' ')
        {
            return FALSE;
        }
        break;
    default:
        return FALSE;
    }

    switch (aContents[2])
    {
    case ' ':
    case '+':
        break;
    default:
        return FALSE;
    }

    return TRUE;
}
