/* POINTERI(ntoInputString).CC, (c) Harry Fluks 1996

   Permission is hereby granted for unlimited modification, use, and
   distribution.  This software is made available with no warranty of
   any kind, express or implied.  This copyright notice must remain
   intact in all versions of this software.

   The author would appreciate it if any bug fixes and enhancements were
   to be sent back to him for incorporation into future versions of this
   software.  Please send changes to fluks4@pi.net

   ----

   96-08-02  created
   96-08-13  checked
*/

#include "pointeri.h"
#include "myinput.h"

PointerIntoInputString::PointerIntoInputString(void)
:
    aPointer(""),  // so pointing to a literal string
    aLength(0),
    aUsedInputString(0)
{
}


PointerIntoInputString::~PointerIntoInputString()
{
    if (aUsedInputString != 0)
    {
        aUsedInputString->pointIntoBuffer(FALSE);
    }
}


bool PointerIntoInputString::empty(void) const
{
    return aLength == 0;
}


int PointerIntoInputString::length(void) const
{
    return aLength;
}


bool PointerIntoInputString::operator==(const PointerIntoInputString & pOther) const
{
    return (  (aLength == pOther.aLength)
           && (strncmp(aPointer, pOther.aPointer, aLength) == 0)
           );
}


bool PointerIntoInputString::operator!=(const PointerIntoInputString & pOther) const
{
    return !(*this == pOther);
}


bool PointerIntoInputString::operator==(const char * pOther) const
{
    return (  (aLength == strlen(pOther))
           && (strncmp(aPointer, pOther, aLength) == 0)
           );
}


bool PointerIntoInputString::operator!=(const char * pOther) const
{
    return !(*this == pOther);
}


char PointerIntoInputString::operator[](int pIndex) const
{
    assert(pIndex >= 0);
    if (pIndex >= aLength)
    {
        return '\0';
    }
    else
    {
        return aPointer[pIndex];
    }
}


int PointerIntoInputString::compare(const PointerIntoInputString & pOther) const
{
    int res = 0;
    if (aLength <= pOther.aLength)
    {
        res = SortOrder::strncmp(aPointer, pOther.aPointer, aLength);
    }
    else
    {
        res = SortOrder::strncmp(aPointer, pOther.aPointer, pOther.aLength);
    }

    if (res == 0)
    {
        if      (aLength < pOther.aLength) return -1;
        else if (aLength > pOther.aLength) return 1;
        else                               return 0;
    }
    else
    {
        return res;
    }
}


int PointerIntoInputString::compare(const char * pOther) const
{
    int res = 0;
    int lOtherLength = strlen(pOther);
    if (aLength <= lOtherLength)
    {
        res = SortOrder::strncmp(aPointer, pOther, aLength);  
    }
    else
    {
        res = SortOrder::strncmp(aPointer, pOther, lOtherLength);
    }

    if (res == 0)
    {
        if      (aLength < lOtherLength) return -1;
        else if (aLength > lOtherLength) return 1;
        else                             return 0;
    }
    else
    {
        return res;
    }
}


bool PointerIntoInputString::equal(const char * pOther) const
{
    if (aLength == strlen(pOther))
    {
        return strncmp(aPointer, pOther, aLength) == 0;
    }
    else
    {
        return FALSE;
    }
}


bool PointerIntoInputString::equalOrLonger(const PointerIntoInputString & pOther) const
{
    if (aLength < pOther.aLength)
    {
        return FALSE;
    }
    else
    {
        return (strncmp(aPointer, pOther.aPointer, pOther.aLength) == 0);
    }
}


bool PointerIntoInputString::equalOrLonger(const char * pOther) const
{
    int lOtherLength = strlen(pOther);
    if (aLength < lOtherLength)
    {
        return FALSE;
    }
    else
    {
        return (strncmp(aPointer, pOther, lOtherLength) == 0);
    }
}


const char * PointerIntoInputString::zeroString(void) const
{
    static LINEtype lBuffer;  // **** DANGEROUS - I'd rather not do this...

    strncpy(lBuffer, aPointer, aLength);
    lBuffer[aLength] = '\0';

    return lBuffer;
}


void PointerIntoInputString::pointTo(const char * p)
{
    if (aUsedInputString != 0)
    {
        aUsedInputString->pointIntoBuffer(FALSE);
        aUsedInputString = 0;
    }
    aLength = strlen(p);
    aPointer = p;
    trimTrail();
}


void PointerIntoInputString::pointTo(MyInputString * p, const char * pPointer, int pLength)
{
    if (aUsedInputString != 0)
    {
        aUsedInputString->pointIntoBuffer(FALSE);
    }
    aUsedInputString = p;
    aUsedInputString->pointIntoBuffer(TRUE);
    aLength = pLength;
    aPointer = pPointer;
    trimTrail();
}


void PointerIntoInputString::copyFrom(const PointerIntoInputString & pOther)
{
    if (aUsedInputString != 0)
    {
        aUsedInputString->pointIntoBuffer(FALSE);
        aUsedInputString = 0;
    }

    if (pOther.aUsedInputString != 0)
    {
        aUsedInputString = pOther.aUsedInputString;
        aUsedInputString->pointIntoBuffer(TRUE);
    }
    aPointer = pOther.aPointer;
    aLength = pOther.aLength;
    trimTrail(); // should not be necessary
}


void PointerIntoInputString::copyToChars(char * pTarget, int pMaxLength) const
{
    if (aLength < pMaxLength)
    {
        strncpy(pTarget, aPointer, aLength);
        pTarget[aLength] = '\0';
    }
    else
    {
        strncpy(pTarget, aPointer, pMaxLength);
        pTarget[pMaxLength] = '\0';
    }
}


void PointerIntoInputString::copyToCharsAligned(char * pTarget, int pLength) const
{
    assert(aLength <= pLength);
    strncpy(pTarget, aPointer, aLength);
    pTarget[aLength] = '\0';
    char * c = MyLib::atend(pTarget);
    for (int i = aLength; i < pLength; i++)
    {
        *c++ = ' ';
    }
    *c = '\0';
}


void PointerIntoInputString::copyToFile(FILE * pTarget) const
{
    const char * c = aPointer;
    for (int i = 0; i < aLength; i++)
    {
        fputc(*c, pTarget);
        c++;
    }
}


void PointerIntoInputString::copyToFileAligned(FILE * pTarget, int pLength) const
{
    assert(aLength <= pLength);
    const char * c = aPointer;
    int i;
    for (i = 0; i < aLength; i++)
    {
        fputc(*c, pTarget);
        c++;
    }
    for (i = aLength; i < pLength; i++)
    {
        fputc(' ', pTarget);
    }
}


void PointerIntoInputString::trimTrail(void)
{
    while (aLength > 0 && aPointer[aLength - 1] == ' ')
    {
        aLength--;
    }
}


EntryOrStoryCode::EntryOrStoryCode(void)
:
    PointerIntoInputString()
{
}


bool EntryOrStoryCode::startsWithWSpace(void)
{
    return (aLength >= 2 && aPointer[0] == 'W' && aPointer[1] == ' ');
}


bool EntryOrStoryCode::plusWIs(const EntryOrStoryCode & pOther) const
{
    return (  (aLength + 2 == pOther.aLength)
           && (strncmp(pOther.aPointer, "W ", 2) == 0)
           && (strncmp(aPointer, pOther.aPointer + 2, aLength) == 0)
           );
}


void EntryOrStoryCode::shiftRight(void)
{
    assert(startsWithWSpace());
    aLength -= 2;
    aPointer += 2;
}


void EntryOrStoryCode::shiftLeft (void)
{
    aLength += 2;
    aPointer -= 2;
    assert(startsWithWSpace());
}
