/* REPORT.H, (c) Harry Fluks 1995

   Permission is hereby granted for unlimited modification, use, and
   distribution.  This software is made available with no warranty of
   any kind, express or implied.  This copyright notice must remain
   intact in all versions of this software.

   The author would appreciate it if any bug fixes and enhancements were
   to be sent back to him for incorporation into future versions of this
   software.  Please send changes to fluks4@pi.net

   ----

   Object: ReportOptions, Report

   Object to make a report in one or more output files. Every file will
   have the right headers and footers, legends, layout, width, and reprint
   information will be printed for the right countries.

   96-01-07  created
   96-08-11  checked
*/

#ifndef Report_H
#define Report_H

#include "external.h"
#include "header.h"

class PersonLegend;

class ReportOptions
// a simple container to ease parameter passing to/from Report
{
public:
    typedef enum
    {
        eSeparateReprintLines,
        eReprintsInColumns,
        eReprintsComments,
        eDescriptionLayout,
        eWebPage
    } LayoutType;

    ReportOptions(Format,
                  const CountrySet pReprintCountrySet,
                  const char pLayoutChar,
                  const int pWidth);

public:
    Format aFormat;
    CountrySet aReprintCountrySet;
    LayoutType aLayout;
    int aWidth;
};


class Report
{
public:
    Report( const FileName & pDefaultName,
            const ReportOptions &,
            bool pInLatin1);

    virtual ~Report();

    void newFile(const char * pName);
    // define the name of a new file, and open it (write headers etc.)

    MyExternalOutputFile & theOutputFile(void);
    // open the file, if necessary, and return it

    void writeEntry(ExternalEntry &);
    // open the file, if necessary, and write the Entry to it
    // using our Format, ReprintCountrySet, Layout and Width.

    void writeHeader(Header &);
    // open the file, if necessary, and write the Header to it

    void startOwnHeader(void);
    void endOwnHeader(void);
    // to be used when a piece of text needs to be put as a header,
    // e.g. at the beginning of a file.
    // These two functions take care of the right amount of
    // empty lines, and / or web-page layout.

    void changeFormat(Format p);
    // also writes new explanation lines, if necessary

protected:
    // properties of the output:
    Format     aFormat;
    CountrySet aReprintCountrySet;
    ReportOptions::LayoutType aLayout;
    int        aWidth;
    bool       aInLatin1;

private:
    void open(const FileName);
    void writeExplanations(void);
    void close(void);

    PersonLegend * aPersonLegend;
    MyExternalOutputFile * aFile;

    FileName aDefaultName;
    // 2 components:
    // - name to use when newFile() wasn't called
    // - extension of all files
};

#endif