/* SELECTED(output).H, (c) Harry Fluks 1995

   Permission is hereby granted for unlimited modification, use, and
   distribution.  This software is made available with no warranty of
   any kind, express or implied.  This copyright notice must remain
   intact in all versions of this software.

   The author would appreciate it if any bug fixes and enhancements were
   to be sent back to him for incorporation into future versions of this
   software.  Please send changes to fluks4@pi.net

   ----

   Object: SelectionOptions, SelectedOutput

   96-04-07  created
   96-08-12  checked
*/

#ifndef SELECTED_H
#define SELECTED_H

#include <stdio.h>
#include "header.h"
#include "report.h"
#include "stogacov.h"

class SelectionOptions
// a simple container to ease parameter passing to/from
// SelectedOutput subclasses
{
public:
    SelectionOptions( const char * pSelector,
                      const StoGaCov pStoGaCov,
                      const CountrySet pCountrySet)
    :
        aSelector(pSelector),
        aStoGaCov(pStoGaCov),
        aCountrySet(pCountrySet)
    {
    }

public: // only to be used by SelectedOutput and subclasses
    const char * aSelector;
    const StoGaCov aStoGaCov;
    const CountrySet aCountrySet;
};


class SelectedOutput: public Report
{
public:
    SelectedOutput( const FileName & pDefaultName,
                    const ReportOptions &,
                    const SelectionOptions &);

    virtual ~SelectedOutput();

    void doit(void);
    // do the actual work: make an output file with the selectied entries

protected:
    virtual bool match(Entry & pEntry) = 0;
    virtual bool headerSmallerThanEntry(const Header &, const Entry &);

    void processFile (const FileName &, CountryIndex);
    void processUnsolvedEntries (void);

    // attributes:
    const char * aSelector;
    const StoGaCov aStoGaCov;
    const CountrySet aCountrySet;
    // countries we want the unsolved entries from (or something else -
    // derived class can redefine its meaning...)
};

#endif