/* SIMILARS(tories).H, (c) Harry Fluks 1996

   Permission is hereby granted for unlimited modification, use, and
   distribution.  This software is made available with no warranty of
   any kind, express or implied.  This copyright notice must remain
   intact in all versions of this software.

   The author would appreciate it if any bug fixes and enhancements were
   to be sent back to him for incorporation into future versions of this
   software.  Please send changes to fluks4@pi.net

   ----

   Object: SimilarStories

   A list of stories that have almost the same code, and are hence candidates
   for an incomplete code in an entry file.

   96-06-30  created
   96-09-03  checked
*/

#include <assert.h>
#include "lastentr.h"
#include "entry.h"

#ifndef SIMILARS_H
#define SIMILARS_H


static const cMaxSimilarStories = 30;

class SimilarStories
{
public:
    SimilarStories(const FileName &);
    ~SimilarStories();

    void goToMatch(const Entry &);
    // read lines from file until the nearest match

    Entry * findBestMatch(Entry &) const;
    // returns 0 if no match or too many matches

private:
    int codesCompare(const Entry &, const Entry &) const;
    bool reasonableMatch(Entry &, Entry &) const;

    Entry * aEntry[cMaxSimilarStories];
    MyDelimitedInputString * aInputString[cMaxSimilarStories];
    // every entry needs an accompanying input string

    int aNumber; // number of entries in the arrays
    LastEntryRead aLastEntryRead;
};

#endif
