/* STORYWIT(hentries).H, (c) Harry Fluks 1995

   Permission is hereby granted for unlimited modification, use, and
   distribution.  This software is made available with no warranty of
   any kind, express or implied.  This copyright notice must remain
   intact in all versions of this software.

   The author would appreciate it if any bug fixes and enhancements were
   to be sent back to him for incorporation into future versions of this
   software.  Please send changes to fluks4@pi.net

   ----

   Object: StoryWithEntries

   An array of Entries, one of them possibly "the" story entry, the other
   ones reprints of that particular story.

   95-07-21  created (from GATHER)
   95-12-08  converted to C++
   96-08-13  checked
*/

#include "definiti.h" // bool
#include "internal.h"
#include "filearra.h"

static const int cMaxEntriesPerStory = 50;
// biggest "user" is W US 7-02 (7-apr-96, still needs more on 22-jan-97)
// on 22-oct-97, the biggest user has become W OS 223-02 + 2 others (more than 40)


struct StoryWithEntriesRecord
{
    typedef enum
    {
        eNoTitle = 0,
        eForeignTitle,
        eOriginalTitle,
        eTitleElsewhere,
        eTitleHere // in order of (usual) importance
    } TitleOrigin;

    typedef enum
    {
        eNoEntry,
        eStoryEntry,
        eReprintEntry,
        eXRefEntry
    } KindOfEntry;

    void init(void);
    void fill(InternalEntry *, MyDelimitedInputString *);

    InternalEntry * sEntry;
    MyDelimitedInputString * sInputString;
    // input string needs to be stored, because sEntry has pointer(s) into it
    TitleOrigin sTitleOrigin;
    KindOfEntry sKindOfEntry;
};


class StoryWithEntries
{
public:
    StoryWithEntries(void);
    virtual ~StoryWithEntries();

    int number(void) const { return aNumber; }
    // the number of elements in the array

    InternalEntry & entry(int) const;
    // the i-th entry in the array

    StoryWithEntriesRecord::TitleOrigin & titleOrigin(int);
    StoryWithEntriesRecord::KindOfEntry & kindOfEntry(int);

    void add(InternalEntry *, MyDelimitedInputString *);
    // Add the Entry to the array.
    // The parameters should be created using 'new': StoryWithEntries will
    // 'delete' them.

    void write( MyInternalOutputFile &, CountryFileArray &) const;
    // write the elements of the array to the corresponding files:
    // one files for the stories, and one file per country for the entries.

    InternalEntry * theStoryEntry(void);
    // find the entry that is 'the' story entry.

protected:
    int aNumber; // the size of the array aRecord
    int aTheStoryIndex; // the one in the array that is "the" story

private:
    StoryWithEntriesRecord aRecord[cMaxEntriesPerStory];

    bool aOverflow; // used for logging
};
