/* SELECTED(output).CC, (c) Harry Fluks 1995

   Permission is hereby granted for unlimited modification, use, and
   distribution.  This software is made available with no warranty of
   any kind, express or implied.  This copyright notice must remain
   intact in all versions of this software.

   The author would appreciate it if any bug fixes and enhancements were
   to be sent back to him for incorporation into future versions of this
   software.  Please send changes to fluks4@pi.net

   ----

   96-04-07  created (from CREATORO)
   96-08-12  checked
*/

#include <assert.h>
#include "selected.h"


class CurrentHeader
{
public:
    CurrentHeader(MyInputFile & pHeaderFile, CountryIndex pCountry);
    ~CurrentHeader();

    Header * readNext(MyDelimitedInputString * &);
    // returns pointer to previous header, plus pointer to accompanying
    // MyInputString

    Header & header(void) { assert(aHeader != 0); return *aHeader; }
    bool endOfFile(void)  { return aHeader == 0; }

private:
    MyDelimitedInputString * aInputString;
    Header * aHeader;
    MyInputFile & aHeaderFile;
    CountryIndex aCountry;
};


CurrentHeader::CurrentHeader(MyInputFile & pHeaderFile, CountryIndex pCountry)
:
    aInputString(0),
    aHeaderFile(pHeaderFile),
    aHeader(0),
    aCountry(pCountry)
{
    aInputString = new MyDelimitedInputString;
    assert(aInputString != 0);
    if (aInputString->read(aHeaderFile) != eEndOfFile)
    {
        aHeader = new Header;
        assert(aHeader != 0);
        aHeader->scanInternal(*aInputString);

        // skip all headers of the wrong countries

        while (  (aHeader != 0) // end of file
              && (aHeader->country() != aCountry)
              )
        {
            delete aHeader;
            aHeader = 0;
            if (aInputString->read(aHeaderFile) != eEndOfFile)
            {
                aHeader = new Header;
                assert(aHeader != 0);
                aHeader->scanInternal(*aInputString);
            }
        }
    }
    // we could assert ((aHeader == 0) || (aHeader->country() == aCountry));
}


CurrentHeader::~CurrentHeader()
{
    if (aHeader != 0)
    {
        delete aHeader;
    }
    if (aInputString != 0)
    {
        delete aInputString; // AFTER deleting aHeader!
    }
}


Header * CurrentHeader::readNext(MyDelimitedInputString * & pInputString)
{
    if (aHeader == 0)
    {
        return 0; // end-of-file
    }

    Header * lResult = aHeader; // caller should delete this one!
    pInputString = aInputString; // and this one too!
    // save a copy, because aI.S. will be overwritten

    aHeader = 0;

    aInputString = new MyDelimitedInputString;
    assert(aInputString != 0);
    if (aInputString->read(aHeaderFile) != eEndOfFile)
    {
        aHeader = new Header;
        assert(aHeader != 0);
        aHeader->scanInternal(*aInputString);
        if (aHeader->country() != aCountry)
        {
            delete aHeader;
            aHeader = 0;  // pseudo-end-of-file
        }
    }
    return lResult;
}


SelectedOutput::SelectedOutput(
    const FileName & pDefaultName,
    const ReportOptions & pReportOptions,
    const SelectionOptions & pSelectionOptions)
:
    Report(pDefaultName, pReportOptions, TRUE), // TRUE = pInLatin1
    aSelector(pSelectionOptions.aSelector),
    aStoGaCov(pSelectionOptions.aStoGaCov),
    aCountrySet(pSelectionOptions.aCountrySet)
{
}


SelectedOutput::~SelectedOutput()
{
}


void SelectedOutput::doit(void)
{
    processFile(FileName("stories", "ins"), eStoryCountry);
    processUnsolvedEntries();
}


bool SelectedOutput::headerSmallerThanEntry(
    const Header & pHeader,
    const Entry & pEntry)
{
    return (pEntry.sStoryCode.compare(pHeader.storyCode()) > 0);
    // can be overruled in derived classes
}


void SelectedOutput::processFile(
    const FileName & p,
    CountryIndex pCountry)
{
    MyInputFile lMyInputFile(p);
    FileName lHeaderFileName("headers1", p);
    MyInputFile lMyHeaderFile(lHeaderFileName);

    CurrentHeader lCurrentHeader(lMyHeaderFile, pCountry);
    MyDelimitedInputString lInputString;

    while (lInputString.read(lMyInputFile) != eEndOfFile)
    {
        if (lInputString.matchAnyText(aSelector))
        // faster if not matching
        {
            ExternalEntry lEntry(aFormat);
            lEntry.scan(lInputString);

            if (match(lEntry)) // more exact test on matching
            {
                Header * lPreviousHeader = 0;
                MyDelimitedInputString * lHeaderInputString = 0;
                while (  (! lCurrentHeader.endOfFile())  // depends on '&&' == 'cand'
                      && headerSmallerThanEntry(lCurrentHeader.header(), lEntry)
                      )
                {
                    if (lPreviousHeader != 0)
                    {
                        delete lPreviousHeader;
                    }
                    if (lHeaderInputString != 0)
                    {
                        delete lHeaderInputString;
                    }
                    lPreviousHeader = lCurrentHeader.readNext(lHeaderInputString);
                }

                // write the header BEFORE the last read header
                if (lPreviousHeader != 0)
                {
                    theOutputFile().printLine();
                    writeHeader(*lPreviousHeader);
                    theOutputFile().printLine();
                    delete lPreviousHeader;
                    delete lHeaderInputString;
                }
                writeEntry(lEntry);
            }
        }
    }
}


void SelectedOutput::processUnsolvedEntries(void)
{
    CountryIndex c;
    while (c.next())
    {
        if (aCountrySet.includes(c))
        {
            bool lFirst = TRUE;
            MyInputFile lMyInputFile(FileName(c.abbreviation(), cStep4Extension));
            MyDelimitedInputString lInputString;

            while (lInputString.read(lMyInputFile) != eEndOfFile)
            {
                if (lInputString.matchAnyText(aSelector)) // faster if not matching
                {
                    ExternalEntry lEntry(aFormat);

                    lEntry.scan(lInputString);
                    if (lEntry.isUnsolved() && match(lEntry))
                    {
                        if (lFirst)
                        {
                            theOutputFile().printLine();
                            startOwnHeader();
                            theOutputFile().printF(
                                "Miscellaneous from %s",
                                c.name());
                            endOwnHeader();
                            lFirst = FALSE;
                        }

                        ENTRYCODEtype lBuffer;
                        lEntry.reprint(lEntry.country()).insert(
                            lEntry.cleanedEntryCode(lBuffer));
// (should be in writeEntry:)
// if entrycode is present, but not printed: add as reprint ****

                        writeEntry(lEntry);
                    }
                }
            }
        }
    }
}
