/* COMMANDL(INE).H, (c) Harry Fluks 1996

   Permission is hereby granted for unlimited modification, use, and
   distribution.  This software is made available with no warranty of
   any kind, express or implied.  This copyright notice must remain
   intact in all versions of this software.

   The author would appreciate it if any bug fixes and enhancements were
   to be sent back to him for incorporation into future versions of this
   software.  Please send changes to fluks4@pi.net

   ----

   Object: CommandLine (+ typedef Option)

   Interpreter of command line options
   Example of supported syntax:

   Name -a string -b -c 5678 -dstringwithoutspace -e string with spaces

   Upper and lower case options are the same.
   An integer argument can not be 0.

   96-05-30  created
   96-08-06  checked
*/

#ifndef COMMANDL_H
#define COMMANDL_H

#include "definiti.h" // bool

typedef char Option;

static const int cMaxArgumentLength = 80;

struct OptionStruct
{
    Option sOption;
    char sArgument[cMaxArgumentLength];
    bool sChecked;
};

class CommandLine
{
public:
    typedef enum
    {
        eMandatory,
        eOptional
    } OptionType;

    typedef enum
    {
        eStringArgument,
        eIntegerArgument,
        eNoArgument
    } ArgumentType;

    CommandLine(int argc, char * argv[]);
    ~CommandLine();

    bool present(Option);

    const char * stringArgument(Option, const char * pDefault = "");
    int integerArgument(Option, int pDefault = 0);
    // these two functions will return the default if !present()

    void check(Option, OptionType, ArgumentType);
    // check the option. An error will be saved and printed when calling
    // printError()
    // If an error occurred before, no checking is done.

    bool printError(const char * pUsage);
    // prints the first occurring error from previous calls to check()
    // If all check()s were OK: prints an error message if options are
    // given that were not specified in a call to check().
    // Hence all possible options should have been specified by check().
    // Also prints a usage message as specified in pUsage.
    // reports on stderr; returns TRUE if error occurred

private:
    OptionStruct * findOption(Option);

    OptionStruct * aOptionStructArray; // dynamically allocated array
    int aAllocatedNumberOfOptions; // possible number of options (from argc)
    int aNumberOfOptions; // real number, <= aAllocatedNumberOfOptions
    const char * aErrorMessage;
    Option aErrorOption; // option printed in error message
};
#endif
