/* COMMENT.H, (c) Harry Fluks 1995

   Permission is hereby granted for unlimited modification, use, and
   distribution.  This software is made available with no warranty of
   any kind, express or implied.  This copyright notice must remain
   intact in all versions of this software.

   The author would appreciate it if any bug fixes and enhancements were
   to be sent back to him for incorporation into future versions of this
   software.  Please send changes to fluks4@pi.net

   ----

   Objects: Comment

   95-03-24  created
   95-12-08  converted to C++
   96-07-18  separated from ShortList
   96-08-16  checked
   96-11-04  class 'Text' removed
*/

#ifndef COMMENT_H
#define COMMENT_H

#include "definiti.h"
#include "myinput.h"

class Comment
{
public:
    Comment(void);
    Comment(const char * p);
    ~Comment();

    void         clear   (void);
    const char * element (void) const;
    bool         empty   (void) const;

    void         append  (const char *);
    void         append  (const PointerIntoInputString &);
    void         append  (const Comment &);

private:
    void         reallocate (int);

    char * aBuffer;
};

#endif
