/* COUNTRY.H, (c) Harry Fluks 1995

   Permission is hereby granted for unlimited modification, use, and
   distribution.  This software is made available with no warranty of
   any kind, express or implied.  This copyright notice must remain
   intact in all versions of this software.

   The author would appreciate it if any bug fixes and enhancements were
   to be sent back to him for incorporation into future versions of this
   software.  Please send changes to fluks4@pi.net

   ----

   Objects: CountryIndex, CountrySet (+ CountryEnum)

   96-08-10  created
   96-08-11  checked
*/

#ifndef COUNTRY_H
#define COUNTRY_H

#include "definiti.h"
#include "pointeri.h"

typedef enum
{
    eGladstoneCountry,
    eWesternCountry,
    eNetherlandsCountry,
    eSwedenCountry,
    eDenmarkCountry,
    eGermanyCountry,
    eFinlandCountry,
    eFranceCountry,
    eNorwayCountry,
    eUnitedKingdomCountry,
    eVariousCountry,
    eItalyCountry,

    eLastCountry,  // eFirst.. and eLast.. for use in arrays
    eNoCountry     // used for Story entries
} CountryEnum;
static const CountryEnum eFirstCountry = eGladstoneCountry;
static const CountryEnum eStoryCountry = eNoCountry;


static const int cPrefixIsReprintPrefix = 12;
// or whatever; used in constructor CountryIndex

class CountryIndex
{
public:
    CountryIndex(void);
    CountryIndex(CountryEnum);
    CountryIndex(const char *);
    CountryIndex(const CountryIndex &);

    CountryIndex(const PointerIntoInputString &);
    // inits from abbreviation

    CountryIndex(const PointerIntoInputString &, int);
    // inits from REPRINT prefix! The 'int' parameter is just to
    // distinguish these two constructors
    // cPrefixIsReprintPrefix can be used for the call.

    void operator=(const CountryIndex & p) { aEnum = p.aEnum; }

    bool next(void);
    bool valid(void) const { return aEnum != eNoCountry; }

    bool isWestern(void)    const { return aEnum == eWesternCountry; }
    CountryEnum number(void) const { return aEnum; }
    // some number, so that countries can be used as index in an array

    const char * name(void) const;
    const char * abbreviation(void) const;
    const char * reprintTitlePrefix(void) const;
    const char * reprintPrefix(void) const;

private:
    CountryEnum aEnum;
};


// we only defined the ones we use (or used to use)...

inline bool operator==(CountryIndex a, CountryIndex b)
{
    return a.number() == b.number();
}


inline bool operator!=(CountryIndex a, CountryIndex b)
{
    return a.number() != b.number();
}


inline bool operator>=(CountryIndex a, CountryIndex b)
{
    return a.number() >= b.number();
}


inline bool operator>(CountryIndex a, CountryIndex b)
{
    return a.number() > b.number();
}


class CountrySet
{
public:
    CountrySet(const char * p = "none");
    // Parameter value:
    // a comma-delimited set of country abbreviations, or
    // "all", or
    // "none".

    void clear(void);
    // makes this an empty set

    void allCountries(void);
    // makes this a complete set

    void insert(const CountryIndex);
    // adds parameter to this set

    bool includes(const CountryIndex &) const;

private:
    bool aPresent[eLastCountry];
};

#endif
