/* CODELIST.CC, (c) Harry Fluks 1994, 1995

   Permission is hereby granted for unlimited modification, use, and
   distribution.  This software is made available with no warranty of
   any kind, express or implied.  This copyright notice must remain
   intact in all versions of this software.

   The author would appreciate it if any bug fixes and enhancements were
   to be sent back to him for incorporation into future versions of this
   software.  Please send changes to fluks4@pi.net

   ----

   96-07-28  created
   96-08-19  checked
*/

#include <assert.h>
#include "codelist.h"
#include "entry.h"

static const int cNamePosition = 15; // counting from 0!


class CodeListElement: public Listable
{
public:
    CodeListElement(const char * pCode, const char * pNewCode);

    int compare(const char *);
    const char * newCode(void) { return aNewCode; }

private:
    STORYCODEtype aCode;
    STORYCODEtype aNewCode;
};


CodeListElement::CodeListElement(
    const char * pCode,
    const char * pNewCode)
{
    strcpy(aCode, pCode);
    strcpy(aNewCode, pNewCode);
}


int CodeListElement::compare(const char * pKey)
{
    assert(pKey != 0);
    return SortOrder::strcmp(aCode, pKey);
}


CodeList::~CodeList()
{
    Listable * l = aList.first();
    Listable * l2;
    while (l != 0)
    {
        l2 = l;
        l = aList.drop(l);  // remove from list
        delete l2;
    }
}


const char * CodeList::findNewCode(const PointerIntoInputString & pCode) const
{
    CodeListElement * lCode =
        (CodeListElement *) aList.find(pCode.zeroString());

    if (lCode == 0)
    {
        return 0;
    }
    else
    {
        return lCode->newCode();
    }
}


void CodeList::read(const FileName & p)
{
    MyFixedPosInputString lInputString;

    MyInputFile lFile(p);

    InputLineType lType;
    while ((lType = lInputString.read(lFile)) != eEndOfFile)
    {
        switch (lType)
        {
        case eCommentLine:
        case eEmptyLine:
            break;
        default:
            {
                STORYCODEtype lCode;
                STORYCODEtype lNewCode;
                lInputString.scanFixedPos(0, STORYCODElength, lCode);
                lInputString.scanFixedPos(
                    cNamePosition, STORYCODElength, lNewCode);

                // insert new code
                CodeListElement * lCodeListElement = new CodeListElement(
                    lCode,
                    lNewCode);
                assert(lCodeListElement != 0);

                (void) aList.insert(lCodeListElement, lCode);
            }
        }
    }

    aList.createIndex();
}
