/* DBFILES.CC, (c) Harry Fluks 1995

   Permission is hereby granted for unlimited modification, use, and
   distribution.  This software is made available with no warranty of
   any kind, express or implied.  This copyright notice must remain
   intact in all versions of this software.

   The author would appreciate it if any bug fixes and enhancements were
   to be sent back to him for incorporation into future versions of this
   software.  Please send changes to fluks4@pi.net

   ----

   95-04-10  created (from definiti.i)
   96-06-02  code for DBI files removed (see header file)
   96-08-12  checked
*/

#include <assert.h>
#include "dbfiles.h"

static const struct
{
    const char * sFileName;   // without the extension
    Format sFormat;

} cDBSFiles[] =
{
    { "FIRST",    eCountryFormat   },
    // NOTE: this list should be sorted by story code!!
    // NOTE 2: we use 8-character MS-DOS-like file names
    { "ar",       eCountryFormat   },
    { "b",        eCountryFormat   },
    { "cb-misc",  eWesternStoryFormat },
    { "d",        eCountryFormat   },
    { "f",        eCountryFormat   },
    { "g",        eCountryFormat   },
    { "h",        eCountryFormat   },
    { "i",        eCountryFormat   },
    { "k",        eCountryFormat   },
    { "rosa-mis", eCountryFormat   },
    { "s",        eCountryFormat   },
    { "w",        eWesternStoryFormat },
    { "yc-yd",    eNewspaperFormat },
    { "ym",       eYMorZTFormat    },
    { "ymg-zs",   eNewspaperFormat },
    { "zt",       eYMorZTFormat    },
    { "zw-zx",    eNewspaperFormat },
    { 0,          eCountryFormat   }
};


bool DBSFileIndex::next(void)
{
    if (cDBSFiles[aIndex].sFileName != 0)
    {
        aIndex++;
    }
    return (cDBSFiles[aIndex].sFileName != 0);
}


const FileName DBSFileIndex::fileName(void) const
{
    assert(aIndex != 0);
    assert(cDBSFiles[aIndex].sFileName != 0);

    if (isWestern())
    {
        return FileName (cDBSFiles[aIndex].sFileName, "dbi");
        // Western files are story AND issue files in one.
    }
    else
    {
        return FileName (cDBSFiles[aIndex].sFileName, "dbs");
    }
}


Format DBSFileIndex::format(void) const
{
    assert(aIndex != 0);
    assert(cDBSFiles[aIndex].sFileName != 0);
    return cDBSFiles[aIndex].sFormat;
}


bool DBSFileIndex::isWestern(void) const
{
    assert(aIndex != 0);
    assert(cDBSFiles[aIndex].sFileName != 0);
    return cDBSFiles[aIndex].sFormat == eWesternStoryFormat;
}


Format DBIFileIndex::format(void) const
{
    if (isWestern())
    {
        return eWesternDBIFormat;
    }
    else
    {
        return eDBIFormat;
    }
}


bool DBIFileIndex::inLatin1(void) const
{
    switch (aCountry.number())
    {
    case eGladstoneCountry:
    case eWesternCountry:
    case eNetherlandsCountry:
    case eUnitedKingdomCountry:
        return FALSE;
    default:
        return TRUE;
    }
}
