/* EXTERNAL(entry).H, (c) Harry Fluks 1995

   Permission is hereby granted for unlimited modification, use, and
   distribution.  This software is made available with no warranty of
   any kind, express or implied.  This copyright notice must remain
   intact in all versions of this software.

   The author would appreciate it if any bug fixes and enhancements were
   to be sent back to him for incorporation into future versions of this
   software.  Please send changes to fluks4@pi.net

   ----

   Object: ExternalEntry + enum Format

   A wrapper around 'InternalEntry' with functions to read and write the Entry
   records from/to (ASCII) files in an 'external' format

   95-03-29  created (extracted from formats.i)
   95-12-08  converted to C++
*/

#ifndef EXTERNAL_H
#define EXTERNAL_H

#include "internal.h"
#include "myinput.h"
#include "myoutput.h"

const char cEarlyTitleChar = '#';


// the various formats of the DBS, DBI, and internal files
typedef enum
{
    // DBS files:
    eWesternStoryFormat,
    eCountryFormat,
    eYMorZTFormat,
    eNewspaperFormat,

    // DBI files:
    eDBIFormat,
    eWesternDBIFormat,

    // output files only:
    eBarksFormat
} Format;


static const bool cCodesOnly = TRUE; // for calls to scanExternal

class ExternalEntry: public InternalEntry
{
public:
    ExternalEntry(Format pFormat): aErrorText(0), aFormat(pFormat) { }

    void convertSpecialFields (void);
    void fillExplanations(ExternalEntry & p2);

    Format format(void) { return aFormat; }
    void changeFormat(Format p) { aFormat = p; }

    void scanExternal         (MyFixedPosInputString &,
                               bool pCodesOnly = FALSE);
    // if pCodesOnly == TRUE, only the sEntryCode and sStoryCode
    // are filled in. There is no check that other fields are not
    // accessed afterwards.

    void putReprintsAsComments(MyExternalOutputFile &,
                               const CountrySet &);

    void putReprintsOnSeparateLines(MyFormattedOutputFile & pFile,
                                    const CountrySet &);

    void putStoryBarks        (MyExternalOutputFile &,
                               bool pWriteReprintsInColumns);

    void putDescriptionLayout (MyExternalOutputFile &);

    void putExternal          (MyExternalOutputFile &);
    // does not write reprints

    static int indentation    (Format);
    // put here because the indentation for followup-lines depends
    // on the implementation of putExternal.

    static void setArrow      (bool);
    // determines whether "->" will be written in external output.
    // by default, no "->" is written.

    const char * aErrorText;
    // set to something != 0 when an error occurred in the scanning.
    // the error is probably only used when checking the input

private:
    void scanShlFields        (MyDelimitedInputString &);
    void scanCommon           (MyFixedPosInputString &,
                               int pPlotterPosition, bool);
    void putCommon            (MyExternalOutputFile &);
    void putPersonText        (MyExternalOutputFile &, ShortListFieldEnum);

    void scanStoryCountry     (MyFixedPosInputString &, bool);
    void putStoryCountry    (MyExternalOutputFile &);
    void scanStoryWestern     (MyFixedPosInputString &, bool);
    void putStoryWestern    (MyExternalOutputFile &);
    void scanStoryYMorZT      (MyFixedPosInputString &, bool);
    void putStoryYMorZT     (MyExternalOutputFile &);
    void scanStoryNewspaper   (MyFixedPosInputString &, bool);
    void putStoryNewspaper  (MyExternalOutputFile &);

    void writeToTheRightColumn( const char * pIssue,
                                ENTRYCODEtype pColumn[],
                                Comment &);
    void writeReprintsInColumns( MyExternalOutputFile &,
                                 const char * pEntryCode,
                                 ShortList & pReprints,
                                 Comment &);
    void scanEntryWestern     (MyFixedPosInputString &, bool);
    void scanEntryFakeWestern (MyFixedPosInputString &);
    void putEntryWestern    (MyExternalOutputFile &);
    void scanEntryCountry     (MyFixedPosInputString &, bool);
    void putEntryCountry    (MyExternalOutputFile &);

    Format aFormat;
    static bool aWriteArrows;
};

#endif
