/* FIELDDEF(inition).H, (c) Harry Fluks 1995

   Permission is hereby granted for unlimited modification, use, and
   distribution.  This software is made available with no warranty of
   any kind, express or implied.  This copyright notice must remain
   intact in all versions of this software.

   The author would appreciate it if any bug fixes and enhancements were
   to be sent back to him for incorporation into future versions of this
   software.  Please send changes to fluks4@pi.net

   ----

   Objects: FieldDefinition, FieldIndex,
            ShortListFieldIndex, HeaderFieldIndex,
            StoryCommentFieldIndex
   plus appropriate enums

   95-12-08  created
   96-08-10  CountryIndex removed
   96-08-13  checked (and restructured)
   96-10-09  StoryCommentFieldIndex added
   96-11-04  TextFieldIndex removed
*/

#ifndef FIELDDEF_H
#define FIELDDEF_H

#include "definiti.h"
#include "pointeri.h"

typedef enum
{
    ePlotter = 0,
    eWriter,
    eArtist,
    eInker,
    eHero,
    eAppearing,

    eCode,
    eSequence,
    eChapter,
    eAlsoReprint,
    eSer,
    eOldCode,
    eOldCodeA,  // ** temporary field
    eOldCodeB,  // ** temporary field
    eExactPages,
    eChanges,

    eOriginalPages,
    eMissingPanels,
    ePart,
    eDate,
    eEndDate,

    eXRef,
    eXRefd,

    eLastShortListField // last one for arrays
} ShortListFieldEnum;


typedef enum
{
    eAltCode = 0,
    eIssueDate,
    ePublisher,
    eIndexer,
    eMinNumber,
    eMaxNumber,
    eReprints,
    eNumberOfIssues,
    eMatla,
    ePrice,
    eIssuePages,
    eLastHeaderField
} HeaderFieldEnum;


typedef enum
{
    eLastName = 0,
    eFirstName,
    eLastNameLatin1,
    eFirstNameLatin1,
    ePseudonym,
    eAlternativeNames,
    eComment,
    eExampleStoryPrefix,
    eExampleStoryCode,
    eExampleStoryTitle,
    eLastPersonField
} PersonFieldEnum;


typedef enum
{
    ePlotterRole, // creators
    eWriterRole,
    eArtistRole,
    eInkerRole,
    eCoverRole,
    eHeroRole,    // heroes
    eAppRole,
    eIndexerRole, // indexers
    eNoRole,      // subseries
    eLastRoleField
} RoleFieldEnum;


typedef enum
{
    eStoryComment = 0,
    eLastStoryCommentField
} StoryCommentFieldEnum;


struct FieldDefinition
{
    const char * sPrefix;
    const char * sExplanation;
};


class FieldIndex
{
public:
    FieldIndex(FieldDefinition * p, int pLast);

    bool next(void);
    bool valid(void) const;
    const char * prefix(void) const;
    const char * explanation(void) const;
    int number(void) const;

protected:
    void initFromPointer(const PointerIntoInputString &);

    int aNumber;
    FieldDefinition * aDefinitionArray;
    int aLast;
};


class ShortListFieldIndex: public FieldIndex
{
public:
    ShortListFieldIndex(void);
    ShortListFieldIndex(ShortListFieldEnum p);
    ShortListFieldIndex(const PointerIntoInputString &);
};


class HeaderFieldIndex: public FieldIndex
{
public:
    HeaderFieldIndex(void);
    HeaderFieldIndex(const PointerIntoInputString &);
};


class PersonFieldIndex: public FieldIndex
{
public:
    PersonFieldIndex(void);
    PersonFieldIndex(const PointerIntoInputString &);
};


class RoleFieldIndex: public FieldIndex
{
public:
    RoleFieldIndex(void);
    RoleFieldIndex(const PointerIntoInputString &);
};


class StoryCommentFieldIndex: public FieldIndex
{
public:
    StoryCommentFieldIndex(void);
    StoryCommentFieldIndex(const PointerIntoInputString &);

    static const char * thePrefix(void);
};


inline int FieldIndex::number(void) const
{
    return aNumber;
}

#endif
