/* FILEARRA(y).H, (c) Harry Fluks 1996

   Permission is hereby granted for unlimited modification, use, and
   distribution.  This software is made available with no warranty of
   any kind, express or implied.  This copyright notice must remain
   intact in all versions of this software.

   The author would appreciate it if any bug fixes and enhancements were
   to be sent back to him for incorporation into future versions of this
   software.  Please send changes to fluks4@pi.net

   ----

   Objects: CountryFileArray, StoryFileArray, StoryFileIndex

   CountryFileArray: Array of MyInternalOutputFiles, one per country.
   StoryFileArray: Array of MyInternalOutputFiles, one per first letter(s)
                   of the story codes.
   StoryFileIndex: object to open the files as MyInputFiles, one at a time
                   (equivalent to CountryIndex etc.)

   Introduced because all information in one file would
   result in a file that's too big.

   96-04-21  created
   96-08-14  checked (introducing CountryFileArray, StoryFileArray)
*/

#ifndef FILEARRA_H
#define FILEARRA_H

#include "country.h"
#include "fielddef.h"
#include "pointeri.h"
#include "myoutput.h"

class CountryFileArray
{
public:
    CountryFileArray(char * pExtension);
    // opens all files for output, country abbrev. is filename

    ~CountryFileArray();
    // closes all files

    MyInternalOutputFile & element(const CountryIndex &);
    // picks right file

private:
    MyInternalOutputFile * aFile[eLastCountry];
};


static const int cMaxStoryFiles = 10; // length of an array in the CC-file


class StoryFileIndex: public FieldIndex
{
public:
    StoryFileIndex(void);
    StoryFileIndex(const EntryOrStoryCode & pStoryCode);
};


class StoryFileArray
{
public:
    StoryFileArray(char * pExtension);
    // opens all files for output, country abbrev. is filename

    ~StoryFileArray();
    // closes all files

    MyInternalOutputFile & element(StoryFileIndex);
    // picks right file

private:
    MyInternalOutputFile * aFile[cMaxStoryFiles];
};

#endif
