/* GATHER(storywithentries).H, (c) Harry Fluks 1997

   Permission is hereby granted for unlimited modification, use, and
   distribution.  This software is made available with no warranty of
   any kind, express or implied.  This copyright notice must remain
   intact in all versions of this software.

   The author would appreciate it if any bug fixes and enhancements were
   to be sent back to him for incorporation into future versions of this
   software.  Please send changes to fluks4@pi.net

   ----

   Object: GatherStoryWithEntries

   97-08-12  created (from GATHER.CC)
   97-09-01  fully objectified
*/

#ifndef GATHER_H
#define GATHER_H

#include "storywit.h"

class GatherStoryWithEntries: public StoryWithEntries
{
public:
    GatherStoryWithEntries(void) {  }
    virtual ~GatherStoryWithEntries() {  }

    void completeEntries(const CountrySet &);

    static void doit(const CountrySet & pAllowedTitleCountries);
    static void addUnsolvedToOutputFileArray(CountryFileArray &);

protected:
    void storyInformationInIssueEntries(void);
    void titlesInAllEntries(const CountrySet &);
    void reprintsAndXRefsInAllEntries(void);

    // this class also abused as a wrapper for our local functions...

    static void takeBestTitle(
        Entry & pTarget,
        Entry & pAlternative,
        StoryWithEntriesRecord::TitleOrigin & pTargetOrigin,
        const CountrySet & pAllowedTitleCountries);

    static void completeEntryWithStoryData(
        Entry & pTarget,
        Entry & pStory);
};

#endif