/* HEADER.H, (c) Harry Fluks 1995

   Permission is hereby granted for unlimited modification, use, and
   distribution.  This software is made available with no warranty of
   any kind, express or implied.  This copyright notice must remain
   intact in all versions of this software.

   The author would appreciate it if any bug fixes and enhancements were
   to be sent back to him for incorporation into future versions of this
   software.  Please send changes to fluks4@pi.net

   ----

   Object: Header

   Header: indication of a file, series, volume, or issue (depending on
   the level).
   Contains general information like issue dates, publisher.

   95-04-10  created
   95-12-08  converted to C++
   96-08-16  checked
*/

#ifndef HEADER_H
#define HEADER_H

#include "definiti.h"
#include "shortlis.h"
#include "entry.h"
#include "myinput.h"
#include "myoutput.h"

class Header
{
public:
    Header(void);
    Header(const CountryIndex &);
    ~Header();

    ShortList & field(HeaderFieldIndex p) { return aHeaders[p.number()]; }
    ShortList & field(HeaderFieldEnum p)  { return aHeaders[p]; }

    void scanInternal (MyDelimitedInputString &);
    void putInternal  (MyInternalOutputFile &, bool pSkipWesternPrefix);
    // pSkipWesternPrefix = TRUE: write "W WDC 123" as "WDC 123", so without
    // the preceding 'W'.

    void scanExternal (MyFixedPosInputString &);
    void putExternal  (MyExternalOutputFile &);
    // also writes the newline! (as opposed to ExternalEntry, who doesn't.)
    void putRawExternal (MyExternalOutputFile &);
    // layout as if it were the input file

    // access to attributes:
    const PointerIntoInputString & storyCode(void) const { return aStoryCode; }
    CountryIndex                   country(void)   const { return aCountry; }
    const PointerIntoInputString & title(void)     const { return aTitle; }
    char                           level(void)     const { return aLevel[0]; }

protected:
    EntryOrStoryCode aStoryCode;
    CountryIndex aCountry;
    PointerIntoInputString aTitle;
    char aLevel[2];
    ShortList aHeaders[eLastHeaderField];
    Comment aComment;
};

#endif
