/* INTERNAL(entry).CC, (c) Harry Fluks 1995

   Permission is hereby granted for unlimited modification, use, and
   distribution.  This software is made available with no warranty of
   any kind, express or implied.  This copyright notice must remain
   intact in all versions of this software.

   The author would appreciate it if any bug fixes and enhancements were
   to be sent back to him for incorporation into future versions of this
   software.  Please send changes to fluks4@pi.net

   ----

   95-03-23  created (using FORMATS.I)
   96-08-16  checked
*/

#include "internal.h"

void InternalEntry::scan(MyDelimitedInputString & pString, bool pCountryOnly)
{
    pString.getDelimitedPointer (sStoryCode);

    {
        PointerIntoInputString lPointer;
        pString.getDelimitedPointer (lPointer);
        CountryIndex lCountry(lPointer);
        setCountry(lCountry);
    }

    if (pCountryOnly)
    {
        // Use with care - we scanned an entry incompletely!

        pString.reset(); // leave it in the condition we got it
        return;
    }

    pString.getDelimitedPointer (sEntryCode);
    pString.getDelimitedString (aUnsolved, 1);

    {
        char lPageBuffer[10]; // 10 = plenty
        pString.getDelimitedString (lPageBuffer, 9);

        if (strlen(lPageBuffer) >= 3)
        {
            if (lPageBuffer[2] == '+')
            {
                sPages.set(lPageBuffer);
                sPages.setBroken(TRUE);
            }
            else
            {
                // this doesn't fit! We *can* have this in the internal
                // field, because it can come from an Italian conversion
                // originally.
                field(eExactPages).insert(lPageBuffer);
            }
        }
        else
        {
            sPages.set(lPageBuffer);
        }
    }

    {
        PREFIXtype lBuffer;
        pString.getDelimitedString (lBuffer, 1);
        sPageLayout = lBuffer;
    }

    {
        PointerIntoInputString lTitlePrefix;
        pString.getDelimitedPointer (lTitlePrefix);
        sTitlePrefix = lTitlePrefix; // calling operator=
    }

    pString.getDelimitedPointer(aTitle);

    PointerIntoInputString lPrefix;
    while (pString.getPrefix(lPrefix, PREFIXlength))
    {
        PointerIntoInputString lPointer;
        pString.getDelimitedPointer(lPointer);

        ShortListFieldIndex s(lPrefix);
        if (s.valid())
        {
            field(s).insert(lPointer);
        }
        else
        {
            CountryIndex c(lPrefix, cPrefixIsReprintPrefix);
            if (c.valid())
            {
                reprint(c).insert(lPointer);
            }
            else
            {
                StoryCommentFieldIndex scf(lPrefix);
                if (scf.valid())
                {
                    storyComment().append(lPointer);
                }
                else
                {
                    comment().append(lPointer);
                }
            }
        }
    }

    pString.reset();
    // leave it in the condition we got it, because we want to be able
    // to scan an inputString more than once (in DVE).
}


void InternalEntry::put(MyInternalOutputFile & pFile)
{
    // first few fields on fixed position because of MSDOS-'sort'
    pFile.putDelimitedStringFixedLength(sStoryCode, STORYCODElength);
    pFile.putDelimitedStringFixedLength(country().abbreviation(), 2);
    pFile.putDelimitedStringWithSpace(sEntryCode);
    // (we need the space because the MS-DOS 'sort' will sort in wrong
    // order otherwise (delimiter < space)....)

    pFile.putDelimitedString(aUnsolved);
    pFile.putDelimitedString(sPages.theString());
    pFile.putDelimitedString(sPageLayout.theString());
    pFile.putDelimitedString(sTitlePrefix.theString());
    pFile.putDelimitedString(aTitle);

    ShortListFieldIndex s;
    while (s.next())
    {
        if (!field(s).empty())
        {
            pFile.putPrefix(s.prefix());
            pFile.putDelimitedString(field(s).delimitedString());
        }
    }
    CountryIndex c;
    while (c.next())
    {
        if (! reprint(c).empty())
        {
            pFile.putPrefix(c.reprintPrefix());
            pFile.putDelimitedString(reprint(c).delimitedString());
        }
    }
    if (! comment().empty())
    {
        pFile.putPrefix("comment"); // anything except..; see scan()
        pFile.putDelimitedString(comment().element());
    }
    if (! storyComment().empty())
    {
        pFile.putPrefix(StoryCommentFieldIndex::thePrefix());
        pFile.putDelimitedString(storyComment().element());
    }
    pFile.putNewLine();
}
