/* LASTENTR(yread).H, (c) Harry Fluks 1995

   Permission is hereby granted for unlimited modification, use, and
   distribution.  This software is made available with no warranty of
   any kind, express or implied.  This copyright notice must remain
   intact in all versions of this software.

   The author would appreciate it if any bug fixes and enhancements were
   to be sent back to him for incorporation into future versions of this
   software.  Please send changes to fluks4@pi.net

   ----

   Object: LastEntryRead

   An object that keeps the last entry from a file. The file contains
   entries in a specific order.

   96-01-07  created (from EntryOutput)
   96-08-11  checked
*/

#include <assert.h>
#include "external.h"
#include "mylib.h"

#ifndef LASTENTR_H
#define LASTENTR_H

static const bool cDeletePrevious = TRUE; // for call to readNext

class LastEntryRead
{
public:
    LastEntryRead(const FileName &);
    ~LastEntryRead();

    void readNext(bool pDeletePrevious);
    // pDeletePrevious can be FALSE e.g. if the previous entry has been put
    // in a container, and hence should not be deleted.

    ExternalEntry & entry(void) const;
    MyDelimitedInputString & inputString(void) const;

private:
    ExternalEntry * aEntry;
    MyDelimitedInputString * aInputString;
    MyInputFile aFile;
};

#endif
