/* LASTENTR(yread).CC, (c) Harry Fluks 1995

   Permission is hereby granted for unlimited modification, use, and
   distribution.  This software is made available with no warranty of
   any kind, express or implied.  This copyright notice must remain
   intact in all versions of this software.

   The author would appreciate it if any bug fixes and enhancements were
   to be sent back to him for incorporation into future versions of this
   software.  Please send changes to fluks4@pi.net

   ----

   96-01-07  created (from EntryOutput)
   96-08-11  checked
*/

#include "lastentr.h"
#include "sortorde.h"

LastEntryRead::LastEntryRead(const FileName & p)
:
    aFile(p),
    aEntry(0)
{
    readNext(FALSE); // read the first entry
}


LastEntryRead::~LastEntryRead()
{
    assert(aEntry != 0);

    if (aEntry->sEntryCode[0] != SortOrderLastChar)
    {
        MyLib::log("Last entry processed: %s", aEntry->sEntryCode.zeroString());
    }
    if (aEntry->sStoryCode[0] != SortOrderLastChar)
    {
        MyLib::log("Last story processed: %s", aEntry->sStoryCode.zeroString());
    }

    delete aEntry;
    delete aInputString;
}


void LastEntryRead::readNext(bool pDeletePrevious)
{
    if (pDeletePrevious)
    {
        delete aEntry;
        // but we can re-use aInputString...
        // (assume aInputString doesn't need re-initialisation; we call
        // "read" anyway)
    }
    else
    {
        // we have to make a new buffer
        aInputString = new MyDelimitedInputString;
    }

    aEntry = new ExternalEntry(eDBIFormat); // format will be set right later
    assert(aEntry != 0);

    if (aInputString->read(aFile) != eEndOfFile)
    {
        aEntry->scan(*aInputString); // scan the INTERNAL format
    }
    else
    {
        static char lTheEnd[2];
        sprintf(lTheEnd, "%c", SortOrderLastChar);

        aEntry->sEntryCode.pointTo(lTheEnd);
        aEntry->sStoryCode.pointTo(lTheEnd);
    }
}


ExternalEntry & LastEntryRead::entry(void) const
{
    assert (aEntry != 0);
    return *aEntry;
}


MyDelimitedInputString & LastEntryRead::inputString(void) const
{
    assert (aInputString != 0);
    return *aInputString;
}
