/* MYLIB.H, (c) Harry Fluks 1994

   Permission is hereby granted for unlimited modification, use, and
   distribution.  This software is made available with no warranty of
   any kind, express or implied.  This copyright notice must remain
   intact in all versions of this software.

   The author would appreciate it if any bug fixes and enhancements were
   to be sent back to him for incorporation into future versions of this
   software.  Please send changes to fluks4@pi.net

   ----

   Objects: MyLib, Progress, FileName

   Progress : reports progress on the screen (and in the logfile)
   MyLib    : some auxiliary string functions, plus a global log function
   FileName : simple class to contain file name and file extension

   94-05-16  created (copied from some other programs)
   94-06-26  completed
   95-12-08  converted to C++
   96-08-23  checked
   97-08-11  removeDuplicateSpaces added
*/

#ifndef MYLIB_H
#define MYLIB_H

#include <stdio.h>
#include "definiti.h" // bool

static const int MAXLINEsize = 500;
typedef char LINEtype[MAXLINEsize];
// used for input and output strings, and other buffers

static const char DELIMITER = '^';
// not chosen at random...

class MyLib
{
public:
    static void log         (const char * pFormat, ...);
    static char * atend     (const char *);
    static void trimtrail   (char *);
    static bool trimnewline (char *);
           // return value: TRUE is a newline was found
    static void addspaces   (char *, int pLength);
    static void removeDuplicateSpaces (char *);
    // also removes all leading spaces

    static void debug       (const char *);
};


class Progress
{
public:
    Progress(void);
    ~Progress();

    static void addRead(void);
    static void addWritten(void);
    static void finish(void);

private:
    void report(int pReportFrequency);

    long aLinesRead;
    long aLinesWritten;
    long aBuffersAllocated;
};


class FileName
{
public:
    FileName(const char * pName, const char * pExtension);
    FileName(const char * pDirectory, const char * pName, const char * pExtension);
    FileName(const FileName &, const char * pOtherExtension);
    FileName(const char * pName, const FileName &);

    void operator=(const FileName &);

    // next 3 return pointer to static buffer
    const char * fullNameNoDir(void) const;
    const char * fullNameInDataDir(void) const;
    const char * fullNameInOrgDir(void) const;

private:
    char aName[40];
    const char * aExtension;
};

#endif
