/* MYLIB.CC, (c) Harry Fluks 1994

   Permission is hereby granted for unlimited modification, use, and
   distribution.  This software is made available with no warranty of
   any kind, express or implied.  This copyright notice must remain
   intact in all versions of this software.

   The author would appreciate it if any bug fixes and enhancements were
   to be sent back to him for incorporation into future versions of this
   software.  Please send changes to fluks4@pi.net

   ----

   94-05-16  created (copied from some other programs)
   94-06-26  completed
   96-08-23  checked (and converted to C++)
*/

#include <string.h>
#include <stdarg.h>  // va_list
#include <assert.h>

#ifdef ONHARRYSPC

#include <time.h>      // timing the processing, won't work under Unix
#define myClock clock()
#include <alloc.h>     // another typical Borland PC-thing

#else

// replace by any values, just to make the code compilable
typedef int clock_t;
#define myClock 3
#define CLK_TCK 4
static long coreleft(void) { return 0L; }

#endif

#include "mylib.h"

void MyLib::log(const char * pFormat, ...)
{
    FILE * lFile = fopen("data/dizni.log", "a");
    if (lFile == 0)
    {
        fprintf(stderr, "\ncannot open file data/dizni.log\n");
        assert(!"cannot write logfile!");
    }

    va_list lVaList;
    va_start(lVaList, pFormat);
    vfprintf(lFile, pFormat, lVaList);
    va_end(lVaList);
    fprintf(lFile, "\n");
    Progress::addWritten(); // log lines also count as output lines!

    (void) fclose(lFile);
}


char * MyLib::atend(const char * pString)
{
    return strchr(pString, 0);
}


void MyLib::trimtrail(char * pString)
{
    if (pString[0] == '\0')
    {
        return;
    }

    char * c = atend(pString) - 1;
    while ((c >= pString) && (*c == ' '))
    {
        *c = '\0';
        c--;
    }
}


bool MyLib::trimnewline(char * pString)
{
    if (pString[0] == '\0')
    {
        return FALSE;
    }

    char * c = atend(pString) - 1;
    if (*c == '\n')
    {
        *c = '\0';
        return TRUE;
    }
    return FALSE;
}


void MyLib::addspaces(char * pString, int pLength)
{
    while (strlen(pString) < pLength)
    {
        strcat(pString, " ");
    }
}


void MyLib::removeDuplicateSpaces (char * p)
{
    char * c = p;
    char * d = p;

    int lSpaces = 1; // start with 1! If we see any leading space, skip it!
    while (*c != '\0')
    {
        assert(d <= c);
        if (*c == ' ')
        {
            lSpaces++;
        }
        else
        {
            lSpaces = 0;
        }

        if (lSpaces == 0 || lSpaces == 1)
        {
            *d = *c; // might be copying to the same place
            d++;
        }

        c++;
    }
    *d = '\0'; // possibly cutting 'p'
}


void MyLib::debug(const char * pText)
{
    static int lFreq = 0;
    lFreq++;
    if (lFreq >= 100)
    {
        fprintf(stdout, "DEBUG [%s] coreleft [%ld]\n", pText, (long) coreleft());
        lFreq = 0;
    }
}


static Progress * gProgress = 0;
static clock_t gStart;
// gStart not an attribute in Progress class because we don't want
// clock_t visible in the header file


Progress::Progress(void)
:
    aLinesRead(0),
    aLinesWritten(0),
    aBuffersAllocated(0)
{
    gStart = myClock;
}


Progress::~Progress()
{
    if (aLinesRead + aLinesWritten > 0)
    {
        report(0);
        clock_t lEnd = myClock;

        long lElapsed = (lEnd - gStart) / CLK_TCK;

        MyLib::log("(time %ld sec)", lElapsed);
        fprintf(stderr, " (time %ld sec)\n", lElapsed);
    }
    // else: probably some error in the arguments. No progress report
    //       necessary.
}


void Progress::addRead(void)
{
    if (gProgress == 0) gProgress = new Progress;
    gProgress->aLinesRead++;
    gProgress->report(500);
}


void Progress::addWritten(void)
{
    if (gProgress == 0) gProgress = new Progress;
    gProgress->aLinesWritten++;
    gProgress->report(500);
}


void Progress::finish(void)
{
    if (gProgress != 0)
    {
        delete gProgress;
    }
}


void Progress::report(int pReportFrequency)
{
    if (pReportFrequency != 0)
    {
        if ((aLinesRead + aLinesWritten) % pReportFrequency != 0)
        {
            return;
        }
    }
    fprintf(stderr, "\rlines read %6ld, lines written %6ld",
                    aLinesRead, aLinesWritten);
#ifdef ONHARRYSPC
    fprintf(stderr, " mem %6ld", coreleft());
#endif
}


FileName::FileName(const char * pName, const char * pExtension)
:
    aExtension(pExtension)
{
    assert(strlen(pName) < 40);
    strcpy(aName, pName);
}


FileName::FileName(const char * pDirectory, const char * pName, const char * pExtension)
:
    aExtension(pExtension)
{
    assert(strlen(pDirectory) + strlen(pName) < 40);
    sprintf(aName, "%s/%s", pDirectory, pName);
}


FileName::FileName(const FileName & p, const char * pOtherExtension)
:
    aExtension(pOtherExtension)
{
    assert(strlen(p.aName) < 40);
    strcpy(aName, p.aName);
}


FileName::FileName(const char * pOtherName, const FileName & p)
:
    aExtension(p.aExtension)
{
    assert(strlen(pOtherName) < 40);
    strcpy(aName, pOtherName);
}


void FileName::operator=(const FileName & p)
{
    assert(strlen(p.aName) < 40);
    strcpy(aName, p.aName);
    aExtension = p.aExtension;
}


const char * FileName::fullNameNoDir(void) const
{
    static char lBuffer[80];
    sprintf(lBuffer, "%s.%s", aName, aExtension);
    return lBuffer;
}


const char * FileName::fullNameInDataDir(void) const
{
    static char lBuffer[80];
    sprintf(lBuffer, "data/%s.%s", aName, aExtension);
    return lBuffer;
}


const char * FileName::fullNameInOrgDir(void) const
{
    static char lBuffer[80];
#ifdef ONHARRYSPC
    sprintf(lBuffer, "\\duk\\original\\%s.%s", aName, aExtension);
#else
    sprintf(lBuffer, "org/%s.%s", aName, aExtension);
#endif
    return lBuffer;
}
