/* PAGELAYO(ut).H, (c) Harry Fluks 1996

   Permission is hereby granted for unlimited modification, use, and
   distribution.  This software is made available with no warranty of
   any kind, express or implied.  This copyright notice must remain
   intact in all versions of this software.

   The author would appreciate it if any bug fixes and enhancements were
   to be sent back to him for incorporation into future versions of this
   software.  Please send changes to fluks4@pi.net

   ----

   Objects: PageLayout, TitlePrefix

   Fields of an Entry that can have only a few well-defined values

   96-08-20  created & checked
   97-07-24  isRealTitle() added
   97-08-01  isStory() added
*/

#ifndef PAGELAYO_H
#define PAGELAYO_H

#include <string.h>  // strcmp
#include "definiti.h" // bool
#include "pointeri.h"

class PageLayout
{
public:
    PageLayout(void): aChar(' ') { }

    void operator=(const PageLayout p)  { aChar = p.aChar; }
    void operator=(const char * p);

    bool operator==(const PageLayout p) const { return aChar == p.aChar; }
    bool operator!=(const PageLayout p) const { return aChar != p.aChar; }

    char theChar(void) const { return aChar; }
    const char * theString(void) const; // use only once at a time...

    bool valid(void) const;
    bool isDefault(void) const { return aChar == ' '; }
    bool isCoverOrSo(void) const;
    bool isPainting(void) const;
    const char * explanation(void) const;
    bool isStory(void) const;

private:
    char aChar;
};


#define TITLEPREFIXlength      4
#define TITLEPREFIXsize        5
typedef char TITLEPREFIXtype[TITLEPREFIXsize]; // "Rnl:" is the biggest

class TitlePrefix
{
public:
    TitlePrefix(void);

    void operator=(const char *);
    void operator=(const PointerIntoInputString &);

    bool operator==(const TitlePrefix & p) const
        { return strcmp(aString, p.aString) == 0; }

    const char * theString(void) const { return aString; }

    bool empty(void) const { return (aString[0] == '\0'); }
    bool valid(void) const;
    bool isRealTitle(void) const; // TRUE if "T:"
    const char * explanation(void) const;

private:
    TITLEPREFIXtype aString;
};

#endif
