/* PERSON.H, (c) Harry Fluks 1997

   Permission is hereby granted for unlimited modification, use, and
   distribution.  This software is made available with no warranty of
   any kind, express or implied.  This copyright notice must remain
   intact in all versions of this software.

   The author would appreciate it if any bug fixes and enhancements were
   to be sent back to him for incorporation into future versions of this
   software.  Please send changes to fluks4@pi.net

   ----

   Object: Person

   Person: a creator, indexer, comic character (hero), or subseries.

   97-09-27  created
*/

#ifndef PERSON_H
#define PERSON_H

#include "definiti.h"
#include "myinput.h"
#include "myoutput.h"
#include "entry.h"
#include "fielddef.h"
#include "shortlis.h"

#define PERSONABBRlength   15
#define PERSONABBRsize     16
typedef char PERSONABBRtype[PERSONABBRsize];

#define PERSONNAMElength   30
#define PERSONNAMEsize     31
typedef char PERSONNAMEtype[PERSONNAMEsize];


class Person
{
public:
    Person(const char * pLastName = 0);
    virtual ~Person();

    void scanInternal (MyDelimitedInputString &, bool pAllFields);
    void putInternal  (MyInternalOutputFile &);
    void scanExternal (MyFixedPosInputString &, bool pCreatorLayout);
    void fullOutput   (MyFormattedOutputFile &);

    const char * fullName(bool pInLatin1) const;

    void update(RoleFieldEnum,
                CountryIndex,
                unsigned short int pNumberOfTimes,
                const PointerIntoInputString * pStoryCode,
                const PointerIntoInputString * pStoryTitle,
                bool pStoryIsFirst);


    // access to attributes:
    ShortList & field(PersonFieldIndex p) const;
    ShortList & field(PersonFieldEnum p) const;

    unsigned short int role(PersonFieldIndex p) const { return aRoleCount[p.number()]; }
    unsigned short int role(PersonFieldEnum p) const  { return aRoleCount[p]; }

    unsigned short int usedIn(CountryIndex p) const { return aUsedIn[p.number()]; }
    unsigned short int usedIn(CountryEnum p) const  { return aUsedIn[p]; }

    bool used(void) const { return aUsed; }
    void setUsed(bool p)  { aUsed = p; }
    const char * abbreviation(void) const { return aAbbreviation; }
    bool hasAbbreviation(void) const;
    const char * key(void) const;

protected:
    PERSONABBRtype aAbbreviation;

    char * aFullName;
    char * aFullNameLatin1;

    ShortList * aField;
    unsigned short int aRoleCount[eLastRoleField];
    unsigned short int aUsedIn[eLastCountry];

    bool aUsed;
};

#endif
