/* PERSONLE(gend).H, (c) Harry Fluks 1994, 1995

   Permission is hereby granted for unlimited modification, use, and
   distribution.  This software is made available with no warranty of
   any kind, express or implied.  This copyright notice must remain
   intact in all versions of this software.

   The author would appreciate it if any bug fixes and enhancements were
   to be sent back to him for incorporation into future versions of this
   software.  Please send changes to fluks4@pi.net

   ----

   Object: PersonLegend

   Lists of creators, heroes, reprints and other stuff
   to be printed as a legend at the end of an output file,
   or to be used to "complete" abbreviated fields.

   95-06-22  created
   95-12-08  converted to C++
   96-07-30  introduction of FilePersonLegend and GlobalPersonLegend
   96-08-13  checked
   97-04-29  abstract class PersonLegend removed
   97-10-14  GlobalPersonLegend removed; FilePersonLegend is now PersonLegend
*/

#ifndef PERSONLE_H
#define PERSONLE_H

#include "personli.h"
#include "seriesli.h"

class PersonLegend
// for legend lines at the end of a file.
{
public:
    PersonLegend(void);
    ~PersonLegend();

    void reInitialise(void);

    void add(Entry &, const CountrySet &);

    const char * find(const char * pKey, ShortListFieldEnum, bool pInLatin1);
    // Returns the full name from the right table, or null if not found.
    // For some shortlist fields there is no table, hence null is returned.

    const char * find(const char * pKey, CountryIndex);
    // Returns the full (reprint) name in the right SeriesList,
    // or null if not found.

    void write(MyExternalOutputFile &, bool pInLatin1);
    void writeWeb(MyExternalOutputFile &); // writes a little less than 'write'

private:
    void writeLocal(MyExternalOutputFile &, bool pWeb, bool pInLatin1);

    PersonList aHeroList;
    PersonList aCreatorList;
    PersonList aSubseriesList;
    SeriesList * aSeriesList[eLastCountry];
    // Lists of series of issues, one for every country
    // Implemented as a pointer, because initialising an array is impossible
    // when a parameter is needed
};

#endif
