/* PREFORMA(tter).H, (c) Harry Fluks 1996

   Permission is hereby granted for unlimited modification, use, and
   distribution.  This software is made available with no warranty of
   any kind, express or implied.  This copyright notice must remain
   intact in all versions of this software.

   The author would appreciate it if any bug fixes and enhancements were
   to be sent back to him for incorporation into future versions of this
   software.  Please send changes to fluks4@pi.net

   ----

   Object: Preformatter

   97-09-01  created
*/

#ifndef PREFORMATTER_H
#define PREFORMATTER_H

#include "definiti.h"
#include "myinput.h"
#include "country.h"
#include "external.h"
#include "dbfiles.h"
#include "filearra.h"
#include "personle.h"

class Preformatter
{
public:
    Preformatter(bool pHeadersOnly);
    ~Preformatter();

    void doit(void);

private:
    void writeInternalHeader(
        MyFixedPosInputString & pString,
        MyInternalOutputFile & pOutputFile,
        MyInternalOutputFile & p1OutputFile,
        const CountryIndex & pCountry,
        bool pSkipWesternPrefix);

    void writeXRef(
        ExternalEntry & pEntry,
        bool pItsAnEntry);

    void processOneStoryFile(
        DBSFileIndex & pFile,
        MyInternalOutputFile & pHeaderFile,
        MyInternalOutputFile & pHeader1File);

    void processOneEntryFile(
        DBIFileIndex & pFile,
        MyInternalOutputFile & pHeaderFile,
        MyInternalOutputFile & pHeader1File,
        MyInternalOutputFile & pUnsolvedFile);

    bool aHeadersOnly;
    StoryFileArray aOutputFileArray;
    PersonList aHeroList;
    PersonList aCreatorList;
    PersonList aSubseriesList;
    PersonList aIndexerList;
};

#endif
