/* PAGELAYO(ut).CC, (c) Harry Fluks 1995

   Permission is hereby granted for unlimited modification, use, and
   distribution.  This software is made available with no warranty of
   any kind, express or implied.  This copyright notice must remain
   intact in all versions of this software.

   The author would appreciate it if any bug fixes and enhancements were
   to be sent back to him for incorporation into future versions of this
   software.  Please send changes to fluks4@pi.net

   ----

   96-08-20  created & checked
*/

#include "pagelayo.h"
#include "country.h"
#include <assert.h>
#include <stdio.h>


void PageLayout::operator=(const char * p)
{
    aChar = p[0];
    if (aChar == '\0')
    {
        aChar = ' ';
    }
}


const char * PageLayout::theString(void) const
{
    static char lBuffer[2];
    lBuffer[0] = aChar;
    lBuffer[1] = '\0';
    return lBuffer;
}


bool PageLayout::valid(void) const
{
    return (explanation()[0] != '?');
}


bool PageLayout::isCoverOrSo(void) const
{
    switch (aChar)
    {
    case 'c':
    case 'i':
    case 'f':
    case 't':
        return TRUE;
    }
    return FALSE;
}


bool PageLayout::isPainting(void) const
{
    switch (aChar)
    {
    case 'P':
    case 'L':
        return TRUE;
    }
    return FALSE;
}


const char * PageLayout::explanation(void) const
{
    switch (aChar)
    {
    case ' ': return "";
    case '1': return "1 row per page";
    case '2': return "2 rows per page";
    case '3': return "3 rows per page";
    case '4': return "4 rows per page";
    case '5': return "5 rows per page";
    case '6': return "6 rows per page";
    case '7': return "7 rows per page";
    case '8': return "8 rows per page";
    case '9': return "9 rows per page";
    case '=': return "printed sideways";
    case 'c': return "cover";
    case 'i': return "illustration";
    case 't': return "text";
    case 'f': return "center fold";
    case 'p': return "photograph";
    case 'P': return "painting - portrait";
    case 'L': return "painting - landscape";
    default:  return "?";
    }
}


bool PageLayout::isStory(void) const
{
    switch (aChar)
    {
    case ' ':
    case '1':
    case '2':
    case '3':
    case '4':
    case '5':
    case '6':
    case '7':
    case '8':
    case '9':
    case '=': return TRUE;
    default:  return FALSE;
    }
}


TitlePrefix::TitlePrefix(void)
{
    aString[0] = '\0';
}


void TitlePrefix::operator=(const char * p)
{
    assert(strlen(p) <= TITLEPREFIXlength);
    strcpy(aString, p);
}


void TitlePrefix::operator=(const PointerIntoInputString & p)
{
    p.copyToChars(aString, TITLEPREFIXlength);
}


bool TitlePrefix::valid(void) const
{
    return (explanation()[0] != '?');
}


bool TitlePrefix::isRealTitle(void) const
{
    return (explanation()[0] == 'T');
}


static const struct
{
    char * sShortPrefix;
    char * sLongerPrefix;
} gPrefixTranslation[] =
{
    {"",  "Title"},
    {"T", "Title"},
    {"R", "Reprint title"},
    {"D", "Description"},
    {"O", "Indexer's description"},
    {"H", "Dutch description"},
    {0, 0}
};


const char * TitlePrefix::explanation(void) const
{
    int i;
    static char lBuffer[40]; // a pointer to it may be returned

    for (i = 0; gPrefixTranslation[i].sShortPrefix != 0; i++)
    {
        if (strcmp(aString, gPrefixTranslation[i].sShortPrefix) == 0)
        {
            return gPrefixTranslation[i].sLongerPrefix;
        }
    }
    // not found; try a reprint tag

    CountryIndex c;
    while (c.next())
    {
        if (strcmp(aString, c.reprintTitlePrefix()) == 0)
        {
            sprintf(lBuffer, "Reprint title from %s", c.name());
            return lBuffer;
        }
    }

    // still not found
    return "??"; // start with '?', this is used in valid()
}
