/* SERIESLI(st).H, (c) Harry Fluks 1996

   Permission is hereby granted for unlimited modification, use, and
   distribution.  This software is made available with no warranty of
   any kind, express or implied.  This copyright notice must remain
   intact in all versions of this software.

   The author would appreciate it if any bug fixes and enhancements were
   to be sent back to him for incorporation into future versions of this
   software.  Please send changes to fluks4@pi.net

   ----

   Object: SeriesList

   A list of series of issues of a specific country (to be used as
   a legend for reprint fields).

   96-04-11  created
   96-08-07  checked (and renamed from IssueList)
*/

#ifndef SERIESLI_H
#define SERIESLI_H

#include "fielddef.h"
#include "entry.h"
#include "linklist.h"


class SeriesList
{
public:
    SeriesList(const CountryIndex &);
    ~SeriesList();

    const char * find(const char * pIssueCode) const;
    // returns the full name of the series, or null if not found
    // note that the number of the issue remains in the output string
    // example:
    //  AA 76-01 ==> Anders And & Co. 76-01
    // return value is a pointer into a static string (!) **

    void useReprintIssues(Entry &);

    void writeFileLegend(MyExternalOutputFile & pOutputFile);
    // is destructive!

    void reInitialise(void);

private:
    void readFromFile(void); // used in constructor

    void add(const char * pIssueCode);

    static void convertIssueCodeToSeriesCode(
        const char * pIssueCode, char * pTarget);

    LinkList aList;
    CountryIndex aCountry;
};

#endif